<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\CronService;
use App\Models\Backend\Order;

class ReSentOrder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order:resend';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run console processes to resend orders to Dropbox.';
    protected $timeout = 0;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            $orders = Order::where('status',1)->get();
            foreach ($orders as $key => $value) {
                $value->uploadPDFToDropbox();
            }
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}