<?php

namespace App\Console\Commands;

use App\Custom\DropboxComponent;
use Illuminate\Console\Command;
use App\Services\CronService;

class SyncStatements extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:statements';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync all statement pdf files from dropbox';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            $result = DropboxComponent::getAllFilesAndFolders('/ls-hosting/monthly statements');
        // \Storage::disk('local')->put('public/imports/statements.json', json_encode($result));
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}
