<?php

namespace App\Console\Commands;

use App\Custom\DropboxComponent;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Backend\Order;
use App\Models\Auth\User;
use App\Models\Backend\OrderStatus;
use App\Models\Backend\ConsumablesOrder;
use App\Models\Backend\StockOrder;
use App\Models\Backend\RxOrders;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class migrate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'migrate:data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Migrate Data with Live Lens Shapers';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');

        //Test Email
        // $user = User::where('ac_code',300)->first();
        // print_r($user->sendWelcomeEmail());exit;
        //End Test Email

        $orders = Order::where('status',1)->get();
        foreach ($orders as $key => $value) {
            $value->uploadPDFToDropbox();
        }exit;
        // $this->syncStatuses();exit;

        //update order shipped
        // $orders = DB::connection('mysql2')
        //                 ->table('lens_order')
        //                 ->select(['id','ship_date','order_date'])
        //                 ->where('status',7)
        //                 ->where('id','<=',126017)
        //                 ->where('id','>',16045)
        //                 ->where('ship_date','!=','0000-00-00 00:00:00')
        //                 ->orderBy('id','asc')
        //                 ->get();
        // foreach ($orders as $key => $value) {
        //     $value->ship_date = $this->validateDate($value->ship_date) ? $value->ship_date : null;
        //     $fields = ['shipped_date'=>$value->ship_date];
        //     if($value->order_date != '0000-00-00 00:00:00' && $this->validateDate($value->order_date)){
        //         $fields['created_at'] = $value->order_date;
        //     }
        //     Order::where('id',$value->id)->update($fields);
        // }
        // exit;
        //end update order shipped

        $users = DB::connection('mysql2')
                        ->table('lens_users')
                        ->where('id','>=',266)
                        ->orderBy('id','asc')
                        ->get();
        foreach ($users as $key3 => $value3) {
            $userModal = User:://where('email',$value3->email)
                        where('ac_code',$value3->code)
                        // ->orWhere('id',$value3->id)
                        ->first();
            $postData = [
                'id'                =>  $value3->id,
                'uuid'              =>  Str::uuid()->toString(),
                'first_name'        =>  $value3->first_name,
                'last_name'         =>  $value3->last_name,
                'email'             =>  $value3->email,
                'password'          =>  Hash::make($value3->password),
                'active'            =>  1,
                'confirmation_code' =>  md5(uniqid(mt_rand(), true)),
                'confirmed'         =>  ($value3->active == '1' && $value3->status == '1') ? 1 : 0,
                'ac_code'           =>  $value3->code
            ];
            $profileData = [
                'business_name'     =>  $value3->business_name,
                'address1'          =>  $value3->address1,
                'address2'          =>  $value3->address2,
                'city'              =>  $value3->city,
                'state'             =>  $value3->state,
                'country'           =>  $value3->country,
                'zip_code'          =>  $value3->zip,
                'phone'             =>  $value3->phone,
                'fax'               =>  $value3->fax,
                'cust_prlist_stock' =>  !empty($value3->stock_pl_code) ? $value3->stock_pl_code : null
            ];
            if(empty($userModal)){
                // $userRepository = new UserRepository();
                // $userModal = $userRepository->create($postData);
                $postData['created_at'] = date('Y-m-d H:i:s');
                $postData['updated_at'] = date('Y-m-d H:i:s');
                if(DB::table('users')->insert($postData)) {
                    $userModal = User::where('id',$value3->id)
                        ->first();
                    $userModal->syncRoles(4);
                }               
            }
            else{
                $userModal->update($postData);
            }
            $userModal->updateProfile($profileData);
            $orders = DB::connection('mysql2')->table('lens_order')
                ->where('user_id',$value3->id)
                ->where('status','!=',0)
                // ->whereBetween('order_date', ['2024-08-31 00:00:00', '2024-09-30 23:59:59'])
                // ->where('id',16045)
                // ->where('id','<=',5000000)
                // ->where('id','>',3000000)
                ->orderBy('id','asc')
                ->chunk(3000, function($orders) use($userModal) {
                    foreach ($orders as $key => $value) {
                        echo $value->id.' |||| ';
                        $order = Order::where('id',$value->id)->first();
                        if(empty($order)){
                            if($value->order_date == '0000-00-00 00:00:00')
                                $value->order_date = $value->ship_date;
                            if($value->ship_date == '0000-00-00 00:00:00')
                                $value->ship_date = null;

                            $value->ship_date = $this->validateDate($value->ship_date) ? convert_date_time_utc($value->ship_date) : null;

                            $value->order_date = $this->validateDate($value->order_date) ? convert_date_time_utc($value->order_date) : null;
                            $value->status_updated = $this->validateDate($value->status_updated) ? convert_date_time_utc($value->status_updated) : null;
                            $value->status_date_time = $this->validateDate($value->status_date_time) ? convert_date_time_utc($value->status_date_time) : null;
                            $value->eta = $this->validateDate($value->eta) && $value->eta != '2999-12-31 00:00:00' ? convert_date_time_utc($value->eta) : null;

                            $statusModal = DB::connection('mysql2')->table('lens_status')
                                    ->where('id',$value->status)
                                    ->first();
                            $statusModal = OrderStatus::where('id',$statusModal->id)->first();
                            if($value->qty > 0){
                                $lensItem = DB::connection('mysql2')->table('av68r_lens_item')
                                    ->where('id',$value->lens_id)
                                    ->first();
                                // if(!empty($lensItem)){
                                    $orderModal = Order::create([
                                        'id'    =>  $value->id,
                                        'user_id' => $userModal->id,
                                        'patient' => $value->patient,
                                        'tray' => $value->patient_tray,
                                        'shipped_date' => $value->ship_date,
                                        'online' => $value->online,
                                        'invoice_no' => $value->invoice,
                                        'tracking_no' => $value->tracking_no,
                                        'is_uploaded' => $value->online,
                                        'type'    => Order::ORDER_CONSUMABLE,
                                        'status'  => $statusModal->id,
                                        'price'   => (float) !empty($lensItem) ? explode('/', $lensItem->price)[0] : 0,
                                        'created_at'     =>  $value->order_date,
                                        'updated_at'     =>  $value->status_updated,
                                        'order_csv'      =>  $value->ordercsv,
                                        'status_date_time' =>  $value->status_date_time,
                                        'eta' =>  $value->eta,
                                    ]);
                                    if(!empty($orderModal)){
                                        $consumablesOrder = ConsumablesOrder::create([
                                            'order_id'      => $orderModal->id,
                                            'name'          => !empty($lensItem) ? $lensItem->name : '',
                                            'sub_name'      => !empty($lensItem) ? $lensItem->sub_name : '',
                                            'description'   => !empty($lensItem) ? $lensItem->desc : '',
                                            'image'         => !empty($lensItem) ? $lensItem->img : '',
                                            'image_hover'   => !empty($lensItem) ? $lensItem->img : '',
                                            'quantity'      => $value->qty,
                                            'misc_sku'      => $value->misc_sku,
                                        ]);
                                    }
                                // }
                            }
                            elseif(!empty($value->r_stock_desc) || !empty($value->l_stock_desc)){
                                $price = 0;
                                $postData = [];
                                if(!empty($value->r_stock_desc)){
                                    // $lensItem = DB::connection('mysql2')->table('lens_stock')
                                    // ->where('sph',$value->r_sphere)
                                    // ->where('cyl',$value->r_cylinder)
                                    // ->first();
                                    $price = $value->r_stock_price;
                                    $postData = [                            
                                        // 'r_material'    => $lensItem->material,
                                        // 'r_colour'      => $lensItem->colour,
                                        // 'r_coating'     => $lensItem->coating,
                                        'r_desc'     => $value->r_stock_desc,
                                        'r_sph'         => $value->r_sphere,
                                        'r_cyl'         => $value->r_cylinder,
                                        'r_size'        => 0,//$lensItem->size,
                                        'r_quantity'    => $value->r_stock_qty,
                                        'r_price'       => (float) $value->r_stock_price,
                                        'r_barcode'       => $value->r_stock_barcode,
                                        'r_cards'       => $value->r_stock_cards,
                                        'r_vendor'       => $value->r_stock_vendor,
                                    ];
                                }
                                if(!empty($value->l_stock_desc)){
                                    // $lensItem = DB::connection('mysql2')->table('lens_stock')
                                    // ->where('sph',$value->l_sphere)
                                    // ->where('cyl',$value->l_cylinder)
                                    // ->first();
                                    $price += $value->l_stock_price;
                                    $temp = [                            
                                        // 'l_material'    => $lensItem->material,
                                        // 'l_colour'      => $lensItem->colour,
                                        // 'l_coating'     => $lensItem->coating,
                                        'l_desc'        => $value->l_stock_desc,
                                        'l_sph'         => $value->l_sphere,
                                        'l_cyl'         => $value->l_cylinder,
                                        'l_size'        => 0,//$lensItem->size,
                                        'l_quantity'    => $value->l_stock_qty,
                                        'l_price'       => (float) $value->l_stock_price,
                                        'l_barcode'       => $value->l_stock_barcode,
                                        'l_cards'       => $value->l_stock_cards,
                                        'l_vendor'       => $value->l_stock_vendor,
                                    ];
                                    $postData = array_merge($temp,$postData);
                                }
                                $orderModal = Order::create([
                                    'id'    =>  $value->id,
                                    'user_id' => $userModal->id,
                                    'patient' => $value->patient,
                                    'tray' => $value->patient_tray,
                                    'shipped_date' => $value->ship_date,
                                    'online' => $value->online,
                                    'invoice_no' => $value->invoice,
                                    'tracking_no' => $value->tracking_no,
                                    'is_uploaded' => $value->online,
                                    'type'    => Order::ORDER_STOCK,
                                    'status'  => $statusModal->id,
                                    'price'   => (float) $price,
                                    'created_at'    =>  $value->order_date,
                                    'updated_at'    =>  $value->status_updated,
                                    'order_csv' =>  $value->ordercsv,
                                    'status_date_time' =>  $value->status_date_time,
                                    'eta' =>  $value->eta,
                                ]);
                                if(!empty($orderModal)){
                                    $type = StockOrder::BOTH_EYES;
                                    if(empty($value->r_stock_desc))
                                        $type = StockOrder::LEFT_EYE;
                                    elseif(empty($value->l_stock_desc))
                                        $type = StockOrder::RIGHT_EYE;

                                    $postData['type'] = $type;
                                    $postData['order_id'] = $orderModal->id;
                                    StockOrder::create($postData);
                                }
                            }
                            else{
                                $metaData = RxOrders::getDefaultArray($value);
                                $lensAttArr = explode("####", trim($value->att_values));
                                $method = 'D';
                                $aShapeIncrease = '';
                                $bShapeIncrease = '';
                                if(!empty($value->att_values) && $value->online){
                                    $method = 'W';
                                    $lensCtArr = ['',''];
                                    if($value->coat_id != '')
                                        $lensCtArr = explode("####", trim($value->coat_values));
                                    
                                    if (trim($value->modify_shape) != "") { 
                                        if ($value->ashapeselect == "+") {
                                            $aShapeIncrease = 'Increase By:';
                                        } else {
                                            $aShapeIncrease = 'Decrease By:';
                                        }
                                    }
                                    
                                    if (trim($value->modify_shape) != "") { 
                                        if ($value->bshapeselect == "+") {
                                            $bShapeIncrease = 'Increase By:';
                                        } else {
                                            $bShapeIncrease = 'Decrease By:';
                                        }
                                    }
                                }
                                $metaData = [
                                    'price' =>  $value->lens_price,
                                    'first_name'    =>  $value->patient,
                                    'last_name'     =>  '',
                                    'special_instructions'  =>  $value->special_instruction,
                                    'lens'  =>   [
                                        'lens_type' =>  $value->lens_title,
                                        'lens_type2'    =>  isset($lensAttArr[0]) ? $lensAttArr[0] : '',
                                        'sub_type'    =>  isset($lensAttArr[1]) ? $lensAttArr[1] : '',
                                        'lens_manufacturer'    =>  '',
                                        'base_curve'    =>  '',
                                        'lens_material'    =>  isset($lensAttArr[2]) ? $lensAttArr[2] : '',
                                        'lens_filter'    =>  isset($lensAttArr[3]) ? $lensAttArr[3] : '',
                                        'lens_colour'    =>  isset($lensAttArr[4]) ? $lensAttArr[4] : '',
                                        'coating_made'    =>  isset($lensCtArr[0]) ? $lensCtArr[0] : '',
                                        'coating_name'    =>  isset($lensCtArr[1]) ? $lensCtArr[1] : '',
                                    ],
                                    'rx'    =>  [
                                        'distance'  =>  [
                                            'right_sph' =>  $value->r_sphere,
                                            'right_cyl' =>  $value->r_cylinder,
                                            'right_axis' =>  $value->r_axis,
                                            'right_oc' =>  $value->r_seg_height,
                                            'left_sph' =>  $value->l_sphere,
                                            'left_cyl' =>  $value->l_cylinder,
                                            'left_axis' =>  $value->l_axis,
                                            'left_oc' =>  $value->l_seg_height,
                                        ],
                                        'prism' =>  [
                                            'right_prism1' => $value->r_prism1,
                                            'right_base1'   =>  $value->r_base1,
                                            'right_prism2' => $value->r_prism2,
                                            'right_base2'   =>  $value->r_base2,
                                            'left_prism1' => $value->l_prism1,
                                            'left_base1'   =>  $value->l_base1,
                                            'left_prism2' => $value->l_prism2,
                                            'left_base2'   =>  $value->l_base2,
                                        ],
                                        'add_for_reading'   =>  [
                                            'right_add' =>  $value->r_add,
                                            'right_boc' =>  '',
                                            'right_sh' =>  $value->r_seg_height,
                                            'right_intermediate_strength' =>  '',
                                            'right_boc' =>  '',
                                            'left_add' =>  $value->l_add,
                                            'left_boc' =>  '',
                                            'left_sh' =>  $value->l_seg_height,
                                            'left_intermediate_strength' =>  '',
                                            'left_boc' =>  ''
                                        ],
                                        'extended_info'=>[
                                            'right_pd'  =>  $value->r_distance_pd,
                                            'right_intermediate_pd'  =>  '',
                                            'right_npd'  =>  $value->r_near_pd,
                                            'right_base_curve'  =>  $value->r_base_curve,
                                            'left_pd'  =>  $value->l_distance_pd,
                                            'left_intermediate_pd'  =>  '',
                                            'left_npd'  =>  $value->l_near_pd,
                                            'left_base_curve'  =>  $value->l_base_curve,
                                        ],
                                        'special_info'=>[
                                            'pento' =>  '',
                                            'wrap'  =>  '',
                                            'tilt'  =>  ''
                                        ]
                                    ],
                                    'frame' =>  [
                                        'job_type'  =>  (strtolower($value->frame) == "enclosed") ? "Edged & Mounted (Frame to Come)" : ucfirst($value->frame),
                                        'frame_type'    =>  $value->frame_type,
                                        'invoice_order_no'  =>  '',
                                        'ft_other'  =>  '',
                                        'specify_thickness' =>  $value->safety_thickness != '' ? 'on' : '',
                                        'safety_stamp'  =>  $value->safety_stamp != "No" ? 'on' : '',
                                        'bevel_type'    =>  '',
                                        'edge_polish'   =>  $value->polish_edge != 0 ? 'on' : '',
                                        'frame_info'    =>  [
                                            'brand' =>  $value->brand,
                                            'model' =>  $value->model,
                                            'colour' =>  $value->color,
                                            'pof' =>  ''
                                        ],
                                        'frame_size'    =>  [
                                            'a' =>  $value->frame_size_a,
                                            'b' =>  $value->frame_size_b,
                                            'ed' =>  $value->frame_size_ed,
                                            'dbl' =>  $value->frame_size_dbl,
                                            'shape' =>  '',
                                            'ed_or_shape'   =>  'ed'
                                        ],
                                        'modify_shape'  =>  [
                                            'a_increased_by'    =>  $aShapeIncrease,
                                            'a_shape_options'   =>  $value->modify_shape_a,
                                            'b_increased_by'    =>  $bShapeIncrease,
                                            'b_shape_options'   =>  $value->modify_shape_b
                                        ],
                                        'specify_thickness' =>  [
                                            'ct_or_et'  =>  !empty($value->thickness_ct_et) ? $value->thickness_ct_et.' mm' : ''
                                        ]
                                    ],
                                    'additional_items'  =>  [
                                        'add_clip_on'   =>  '',
                                        'add_repairs'   =>  '',
                                        'clip_on_list'  =>  '',
                                        'repair_description'    =>  ''
                                    ],
                                    'is_tinting'  =>  $value->is_tinting,
                                    'tint_option'  =>  $value->tint_option,
                                    'tint_color_sample'  =>  $value->tint_color_sample,
                                    'tinting'  =>  $value->tinting,
                                    'edging'  =>  $value->edging,
                                    'coat_id'  =>  $value->coat_id,
                                    'coat_price'  =>  $value->coat_price,
                                    'coat_values'  =>  $value->coat_values,
                                    'reader'  =>  $value->reader,
                                    'att_values'  =>  $value->att_values,
                                    'group_values'  =>  $value->group_values,
                                    'tint_title'  =>  '',
                                    'is_multipair'  =>  $value->is_multipair == 1 ? 'on' : '',
                                    'multipair_ref' =>  $value->multipair_ref
                                ];
                                $orderModal = Order::create([
                                    'id'    =>  $value->id,
                                    'user_id' => $userModal->id,
                                    'patient' => $value->patient,
                                    'tray' => $value->patient_tray,
                                    'shipped_date' => $value->ship_date,
                                    'online' => $value->online,
                                    'invoice_no' => $value->invoice,
                                    'tracking_no' => $value->tracking_no,
                                    'is_uploaded' => 1,
                                    'type'    => Order::ORDER_RX,
                                    'status'  => $statusModal->id,
                                    'price'   => $value->lens_price,
                                    'created_at'    =>  $value->order_date,
                                    'updated_at'    =>  $value->status_updated,
                                    'order_csv' =>  $value->ordercsv,
                                    'status_date_time' =>  $value->status_date_time,
                                    'eta' =>  $value->eta,
                                    'method'    =>  $method
                                ]);
                                if(!empty($orderModal)){
                                    RxOrders::create([
                                        'order_id' => $orderModal->id,
                                        'first_name'  => $value->patient,
                                        'last_name'  => '',
                                        'data'  => json_encode($metaData),
                                    ]);
                                }
                            }
                        }
                    } 
                });
        }
    }

    private function syncStatuses(){
        // OrderStatus::truncate();
        $statusModal = DB::connection('mysql2')->table('lens_status')->get();
        foreach ($statusModal as $key => $value) {
            OrderStatus::create([
                'id'    =>  $value->id,
                'name'  =>  str_replace(' ', '_', strtolower($value->title)),
                'title'    =>  $value->title,
                'color'    =>  $value->color,
                'active'    =>  $value->active,
            ]);
        }
    }
    public function validateDate($date, $format = 'Y-m-d H:i:s')
    {
        // Enforce strict 4-digit year with a regex
        $regex = '/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/';

        // Check if the input date matches the strict format
        if (preg_match($regex, $date)) {
            // Manually extract the year and validate it's within a valid range
            $year = substr($date, 0, 4);

            if ((int)$year < 1000 || (int)$year > 9999) {
                return false; // Invalid year if it's outside the 4-digit range
            }

            // Now validate the date using DateTime::createFromFormat
            $d = \DateTime::createFromFormat($format, $date);

            // Ensure that the date matches the format exactly
            return $d && $d->format($format) === $date;
        }

        // Return false if the regex fails
        return false;
    }
}
