<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

/**
 * Class Kernel.
 */
class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        \App\Console\Commands\ImportCsv::class,
        \App\Console\Commands\SyncStatements::class,
        \App\Console\Commands\CronScheduled::class,
        \App\Console\Commands\SyncFramesData::class,
        \App\Console\Commands\uploadDropboxFiles::class
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     */
    protected function schedule(Schedule $schedule)
    {
        // These run every minute regardless of timezone
        $schedule->command('cron:scheduled')->everyMinute();
        $schedule->command('send:notifications')->everyMinute();
        $schedule->command('order:resend')->hourly();

        // Import credit memos at 12 AM EST (original: 5 AM UTC)
        $schedule->command('import:csv "credit_memos"')
            ->weekdays()
            ->at('00:00')
            ->timezone('America/Toronto');

        // Sync statements at 1 PM EST (original: 6 PM UTC)
        $schedule->command('sync:statements')
                ->weekdays()
                ->at('13:00')
                ->timezone('America/Toronto');

        // For 9 AM to 6 PM EST (UTC-5)
        $schedule->command('import:csv "customers"')
            ->weekdays()
            ->everyFifteenMinutes()
            ->between('9:00', '18:00')
            ->timezone('America/Toronto')
            ->withoutOverlapping();

        // For 7 AM to 5 PM EST (UTC-5)
        $schedule->command('import:csv "web_order_status"')
            ->weekdays()
            ->everyThirtyMinutes()
            ->between('7:00', '17:00')
            ->timezone('America/Toronto');

        $schedule->command('export:orders')
                ->dailyAt('5:00')  // 9 AM server time
                ->timezone('America/Toronto');

        // Example for 4 AM EST (9 AM UTC)
        $schedule->command('duplicate:orders')
                ->dailyAt('4:00')
                ->timezone('America/Toronto');
            

        // Sync frame data at 1 AM Sunday EST (original: 23:00 UTC Sunday = 7 PM EST Sunday)
        $schedule->command('syncFrameData:run')
            ->sundays()
            ->at('01:00')
            ->timezone('America/Toronto');

        // Export frame CSV at 11 PM Sunday EST (original: 7 AM UTC Monday = 2 AM EST Monday)
        $schedule->command('exportFrameCsv:run')
            ->sundays()
            ->at('06:00')
            ->timezone('America/Toronto');
    }
    /**
     * Register the commands for the application.
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
