<?php

namespace App\Custom;

use Spatie\Dropbox\Client;
use League\Flysystem\Filesystem;
use Spatie\FlysystemDropbox\DropboxAdapter;
use GuzzleHttp\Exception\ServerException;

class DropboxComponent {

    /**
     * Sync Dropbox files 
     */
    public static function syncDrpboxFiles($path,$fileName,$is_save = true) {

        $file_path = public_path('imports/'.$fileName);
        // Delete existing file
        if (file_exists($file_path)) {
        //    unlink($file_path);
        }

        // configurations
        $token          = config('access.api.dropbox.auth_token');
        $client_id      = config('access.api.dropbox.client_id');
        $client_secret  = config('access.api.dropbox.secret_id');

        // Initiate API
        $client = new Client($token);

        // // List all folders from user's dropbox account
        // $folders    = $client->listFolder($path);

        // // Get fille name of desired file
        // $fileName   = $folders['entries'][3]['name'];
        // // Get file path of desired file
        // $path       = $folders['entries'][3]['path_lower'];

        // Download file
        $contents = '';
        try {
            if($path == '')
                $path = $fileName;
            else
               $path = $path.'/'.$fileName;

            $contents = $client->download($path);
        } catch (\Throwable $th) {
            //throw $th;
        }catch (GuzzleHttp\Exception\ServerException $th) {
            //throw $th;
        }
        if(!empty($contents) && $is_save){
            file_put_contents(public_path('imports/') . $fileName, $contents);
            return true;
        }

        return $contents;
    } 

    /**
     * Sync Dropbox files 
     */
    public static function getTemporaryUrl($path,$fileName,$is_save = true) {

        $file_path = public_path('imports/'.$fileName);
        // Delete existing file
        if (file_exists($file_path)) {
            unlink($file_path);
        }

        // configurations
        $token          = config('access.api.dropbox.auth_token');
        $client_id      = config('access.api.dropbox.client_id');
        $client_secret  = config('access.api.dropbox.secret_id');

        // Initiate API
        $client     = new Client($token);

        // // List all folders from user's dropbox account
        // $folders    = $client->listFolder($path);

        // // Get fille name of desired file
        // $fileName   = $folders['entries'][3]['name'];
        // // Get file path of desired file
        // $path       = $folders['entries'][3]['path_lower'];

        // Download file
        $contents = '';
        try {
            $link = $client->getTemporaryLink($path.'/'.$fileName);
            $contents = $link['link'] ?? '';
        } catch (\Throwable $th) {
            //throw $th;
        }catch (GuzzleHttp\Exception\ServerException $th) {
            //throw $th;
        }

        return $contents;
    } 
    /**
     * Upload order pdf to dropbox
     * 
     * @param $filePath
     * @param $fileName
     */
    public static function uploadPdf($filePath, $fileName, $path = '') {
        
        // configurations
        $token          = config('access.api.dropbox.auth_token');
        $client_id      = config('access.api.dropbox.client_id');
        $client_secret  = config('access.api.dropbox.secret_id');

        // Initiate API
        $client     = new Client($token);

        // $folders    = $client->listFolder($path);

        $client->upload($path.$fileName, file_get_contents($filePath), 'overwrite');
        // unlink($filePath);
    }

    /**
     * Get Invoice File
     */
    public static function getInvoice($invoice) {
        $path = '/invoice pdfs';
        // configurations
        $token          = config('access.api.dropbox.auth_token');
        $client_id      = config('access.api.dropbox.client_id');
        $client_secret  = config('access.api.dropbox.secret_id');

        // Initiate API
        $client     = new Client($token);
        // Download file
        try {
            $fileName = $invoice.'.pdf';
            $contents = $client->download($path.'/'.$fileName);
            if (is_resource($contents)) {
                $contents = stream_get_contents($contents);
            }
            $fileName = 'LS-Invoice-'.$invoice.'.pdf';
            $filePath = storage_path('app/public/invoices/'.$fileName);
            \Storage::disk('public')->put('invoices/'.$fileName, $contents);
            return route('frontend.files.invoice', $fileName);
        } catch (\Throwable $e) {

        }
        return false;
    }

    /**
     * Get Invoice File
     */
    // public static function getAllFilesAndFolders($path) {
    //     ini_set('max_execution_time', 0);
    //     // configurations
    //     $token          = config('access.api.dropbox.auth_token');
    //     $client_id      = config('access.api.dropbox.client_id');
    //     $client_secret  = config('access.api.dropbox.secret_id');

    //     // Initiate API
    //     $app        = new DropboxApp($client_id, $client_secret, $token);
    //     $dropbox    = new Dropbox($app);
    //     $client     = new Client($token);

    //     // // List all folders from user's dropbox account
    //     $folders    = $client->listFolder($path);
    //     $data = [];
    //     foreach ($folders['entries'] as $key => $value) {
    //         if(empty($data)){
    //             $path = storage_path('app/public/imports/statements.json');
    //             $data = json_decode(file_get_contents($path), true); 
    //         }
    //         $data[$key] = [
    //             'name'  =>  $value['name'],
    //             'is_child' =>  true,
    //             'entries'  =>  []
    //         ];
    //         if($value['.tag'] == 'folder'){
    //             $subFolders    = $client->listFolder($value['path_lower']);
    //             foreach ($subFolders['entries'] as $key2 => $value2) {
    //                 $data[$key]['entries'][$key2] = [
    //                     'name'  =>  $value2['name'],
    //                     'is_child' =>  true,
    //                     'entries'  =>  []
    //                 ];
    //                 if($value['.tag'] == 'folder'){
    //                     $allFiles    = $client->listFolder($value2['path_lower']);
    //                     foreach ($allFiles['entries'] as $key3 => $value3) {
    //                         // if($value3['is_downloadable'] == 1){
    //                         //     try {
    //                         //         $file = $dropbox->download($value3['path_lower']);
    //                         //         $contents = $file->getContents();
    //                         //         $ext = pathinfo($value3['path_lower'], PATHINFO_EXTENSION);

    //                         //         $fileName = md5($value3['name'] . microtime()).'.'.$ext;
    //                         //         $filePath = storage_path('app/public/statements/'.$fileName);
    //                         //         \Storage::disk('public')->put('statements/'.$fileName, $contents);
    //                         //         $url = $fileName;//url('storage/app/public/statements/'.$value3['name']);
    //                         //     }
    //                         //     catch (\Kunnu\Dropbox\Exceptions\DropboxClientException $e) {
    //                         //     }
    //                         // }
    //                         $data[$key]['entries'][$key2]['entries'][$key3] = [
    //                             'name'  =>  $value3['name'],
    //                             'is_child' =>  false,
    //                             'path'   =>  $value3['path_lower']
    //                         ];
    //                         \Storage::disk('local')->put('public/imports/statements.json', json_encode($data));
    //                     }
    //                 }
    //             }
    //         }
    //     }
    //     return $data;
    //     // echo "<pre>";
    //     // print_r($data);exit;
    // } 
    /**
     * Get all files and folders from Dropbox while maintaining the original structure.
     */
    public static function getAllFilesAndFolders($path) {
        ini_set('max_execution_time', 0);
        
        // Configuration
        $token = config('access.api.dropbox.auth_token');
        $client_id = config('access.api.dropbox.client_id');
        $client_secret = config('access.api.dropbox.secret_id');

        // Initiate API
        $client     = new Client($token);

        // Load existing data
        // $dataPath = storage_path('app/public/imports/statements.json');
        $data = [];//file_exists($dataPath) ? json_decode(file_get_contents($dataPath), true) : [];

        // List all folders from the user's Dropbox account
        $folders = $client->listFolder($path);

        foreach ($folders['entries'] as $key => $value) {
            // Initialize the data if empty
            if (empty($data)) {
                $data = [];
            }

            // Prepare the data entry for the current folder
            $data[$key] = [
                'name' => $value['name'],
                'is_child' => true,
                'entries' => []
            ];

            // Process sub-folders and files
            if ($value['.tag'] == 'folder') {
                $subFolders = $client->listFolder($value['path_lower']);
                foreach ($subFolders['entries'] as $key2 => $value2) {
                    $subFolderData = [
                        'name' => $value2['name'],
                        'is_child' => true,
                        'entries' => []
                    ];

                    // If it's a sub-folder, list its contents
                    if ($value2['.tag'] == 'folder') {
                        $allFiles = $client->listFolder($value2['path_lower']);
                        foreach ($allFiles['entries'] as $key3 => $value3) {
                            $subFolderData['entries'][] = [
                                'name' => $value3['name'],
                                'is_child' => false,
                                'path' => $value3['path_lower']
                            ];
                        }
                    }

                    // Append sub-folder data to the main folder
                    $data[$key]['entries'][] = $subFolderData;
                }
            }

            // Save data gradually after processing each folder
            \Storage::disk('local')->put('public/imports/statements.json', json_encode($data, JSON_PRETTY_PRINT));
        }

        return $data;
    }
}