<?php

namespace App\Helpers\Global;

/**
 * Active Helper Class for checking URI patterns and routes.
 */
class Active
{
    /**
     * Check if the current URI matches the given pattern.
     *
     * @param string $pattern
     * @return bool
     */
    public static function checkUriPattern($pattern)
    {
        $currentUri = request()->getPathInfo();

        // Replace * with .* for regex
        $pattern = str_replace('*', '.*', $pattern);

        // Add ^ and $ to match full path
        $pattern = '^/' . $pattern . '.*$';

        return preg_match('#' . $pattern . '#', $currentUri);
    }

    /**
     * Check if the current route matches the given route name.
     *
     * @param string $route
     * @return bool
     */
    public static function checkRoute($route)
    {
        return \Route::currentRouteName() === $route;
    }
}