<?php
use Picqer\Barcode\BarcodeGeneratorPNG;
use Illuminate\Support\Facades\Cache;
use App\Models\Backend\Order;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;

if (! function_exists('app_name')) {
    /**
     * Helper to grab the application name.
     *
     * @return mixed
     */
    function app_name()
    {
        return config('app.name');
    }
}

if (! function_exists('gravatar')) {
    /**
     * Access the gravatar helper.
     */
    function gravatar()
    {
        return app('gravatar');
    }
}

if (! function_exists('home_route')) {
    /**
     * Return the route to the "home" page depending on authentication/authorization status.
     *
     * @return string
     */
    function home_route()
    {
        if (auth()->check()) {
            if (auth()->user()->can('view backend')) {
                return 'admin.orders.list';
            }

            return 'frontend.user.common.dashboard';
        }

        return 'frontend.index';
    }
}

if (! function_exists('date_time_format')) {
    /**
     * Return the route to the "home" page depending on authentication/authorization status.
     *
     * @return string
     */
    function date_time_format($dateTime,$format)
    {
        // Assuming $this->created_at is in UTC or a known timezone
        $createdAt = new \DateTime($dateTime);

        // Convert the timezone to Eastern Standard Time (EST)
        $createdAt->setTimezone(new \DateTimeZone('America/New_York'));

        // Format the date as per your requirement
        $formattedDate = $createdAt->format($format);

        return $formattedDate;
    }
}

if (! function_exists('convert_date_time_utc')) {
    /**
     * Return the route to the "home" page depending on authentication/authorization status.
     *
     * @return string
     */
    function convert_date_time_utc($dateTime, $format = 'Y-m-d H:i:s', $timezone = 'America/New_York')
    {
        try {
            // Create a Carbon instance in the specified time zone
            $carbonDate = \Carbon\Carbon::createFromFormat($format, $dateTime, $timezone);

            // Check if the time is valid in that time zone
            if (!$carbonDate->isValid()) {
                // If not valid, adjust it to the next valid time (e.g., 3 AM or later)
                $carbonDate = $carbonDate->addHour();
            }

            // Convert to UTC
            $carbonUtc = $carbonDate->setTimezone('UTC');

            // Return the formatted UTC datetime
            return $carbonUtc->format($format);
        } catch (\Exception $e) {
            return null;  // Handle any errors gracefully
        }
    }
}

if (! function_exists('custom_encode_hashids')) {
    /**
     *
     * @return string
     */
    function custom_encode_hashids($string,$type,$length = 40)
    {
        $hashid = new \Hashids\Hashids('LSc441szpZ9DhpLWeuq4xgXfrJpncRx1mrzTZ32'.$type,$length);
        return $hashid->encode($string);
    }
}

if (! function_exists('custom_decode_hashids')) {
    /**
     *
     * @return string
     */
    function custom_decode_hashids($string,$type,$length = 40)
    {
        $hashid = new \Hashids\Hashids('LSc441szpZ9DhpLWeuq4xgXfrJpncRx1mrzTZ32'.$type,$length);
        $id = $hashid->decode($string);
        if(!empty($id))
            return $id[0];

        return null;
    }
}

if (! function_exists('custom_encode_path')) {
    /**
     *
     * @return string
     */
    function custom_encode_path($string,$type,$length = 40)
    {
        return base64_encode($string);
    }
}

if (! function_exists('custom_decode_path')) {
    /**
     *
     * @return string
     */
    function custom_decode_path($string,$type,$length = 40)
    {
        return base64_decode($string);
    }
}
if(!function_exists('roundToNearestQuarter')){
    function roundToNearestQuarter($number) {
        $rounded = round($number * 4) / 4; // Round to the nearest 0.25
        return number_format($rounded, 2, '.', ''); // Ensure two decimal places
    }
}

if (!function_exists('generateBarcode')) {
    /**
     * Generate a barcode as a base64-encoded PNG image
     *
     * @param string $data The data for the barcode
     * @param string $type The barcode type (e.g., TYPE_CODE_128)
     * @param int $scale The scale of the barcode (width of the bars)
     * @param int $height The height of the barcode
     * @return string Base64 encoded image
     */
    function generateBarcode($data, $height = 50,$scale = 2,$type = BarcodeGeneratorPNG::TYPE_CODE_128)
    {
        $generator = new BarcodeGeneratorPNG();
        if(!empty($data)){
            $barcode = $generator->getBarcode($data, $type, $scale, $height);

            return 'data:image/png;base64,' . base64_encode($barcode);
        }
        return '';
    }
}

if (!function_exists('sendErrorEmail')) {
    /**
     * Generate a barcode as a base64-encoded PNG image
     *
     * @param string $data The data for the barcode
     * @param string $type The barcode type (e.g., TYPE_CODE_128)
     * @param int $scale The scale of the barcode (width of the bars)
     * @param int $height The height of the barcode
     * @return string Base64 encoded image
     */
    function sendErrorEmail($subject,$message)
    {
        \Illuminate\Support\Facades\Mail::raw($message, function ($mail) use ($subject) {
            $mail->to('info@lens-shapers.com')
            ->bcc('usama485@gmail.com')
                    ->subject($subject);
        });
    }
}

if(!function_exists('sendEmail')) {

    function sendEmail($htmlTable, $emailTo, $replyToEmail, $subject)
    {
        try {
            \Mail::send([], [], function($message) use ($htmlTable, $emailTo, $replyToEmail, $subject) {
                $message->to($emailTo)
                        ->from($emailTo)
                        ->replyTo($replyToEmail)
                        ->subject($subject)
                        ->setBody($htmlTable, 'text/html');
            });
        return true;
        } catch (\Exception $e) {
            \Log::error('Failed to send email: ' . $e->getMessage());
            return false;
        }
    }
}

if(!function_exists('clearCustomCache')) {

    function clearCustomCache($type)
    {
        switch ($type) {
            case 'rx':
                Cache::tags([app()->environment() . '_rx_validation'])->flush();
                Cache::tags([app()->environment() . '_rx_keys_validation'])->flush();
                break;
            case 'frame_info':
                Cache::tags([app()->environment() . '_frame_info'])->flush();
                break;
            case 'all':
                Cache::tags([app()->environment() . '_rx_validation'])->flush();
                Cache::tags([app()->environment() . '_rx_keys_validation'])->flush();
                Cache::tags([app()->environment() . '_frame_info'])->flush();
                break;
            case 'config':
                Artisan::call('config:clear');
                Artisan::call('route:clear');
                Artisan::call('view:clear');
                break;
        }
        return true;
    }
}

if(!function_exists('numberOfSubmittedOrder')) {

    function numberOfSubmittedOrder()
    {
        return Order::where('status', 1)
            ->where('created_at', '<', Carbon::now()->subMinutes(60))
            ->count();
    }
}


if (!function_exists('formatPhone')) {

    function formatPhone($phone) {
        $cleaned = preg_replace('/\D/', '', $phone);
        if (strlen($cleaned) > 12) $cleaned = substr($cleaned, -12);
        if (strlen($cleaned) === 12) return preg_replace('/(\d{2})(\d{3})(\d{3})(\d{4})/', '$1-$2-$3-$4', $cleaned);
        elseif (strlen($cleaned) === 11) return preg_replace('/(\d{1})(\d{3})(\d{3})(\d{4})/', '$1-$2-$3-$4', $cleaned);
        elseif (strlen($cleaned) === 10) return preg_replace('/(\d{3})(\d{3})(\d{4})/', '$1-$2-$3', $cleaned);
        return $phone;
    }
}

if (!function_exists('versioned_asset')) {
    function versioned_asset($path) {
        return asset($path) . '?v=' . trim(exec('git rev-parse --short HEAD'));
    }
}

if (!function_exists('svg_image')) {

    function svg_image($path, $class = 'svg-icons', $alt = 'SVG Icon')
    {
        $src = asset('public/storage/svg/' . ltrim($path, '/'));
        return '<img class="' . e($class) . '" src="' . $src . '" alt="' . e($alt) . '">';
    }
}

if (!function_exists('displayNewCustomerWarning')) {
    /**
     * Display a warning message if the user was created within the last 60 days.
     *
     */
    function displayNewCustomerWarning($createdAt, $type)
    {
        $isNewCustomer = Carbon::parse($createdAt)->diffInDays(now()) <= 60;
        $string = '*** Special Attention, New Customer ***';
        if ($isNewCustomer) {
            if($type == 'print') {
                // return '<td colspan="2" align="center"><span style="color: white; font-weight: bold; text-align: center; display: block; background-color: black; margin: 1px; font-size: 14px;">'. $string .'</span></td>';
                return '<td colspan="3" align="center"><span style="color: white; font-weight: bold; text-align: center; display: block; background-color: black; margin: 1px; font-size: 14px;">'. $string .'</span></td>';
            } else {
                return '<span style="color: white; font-weight: bold; background-color: black; font-size: 14px; display: block; margin: 2px;">'. $string .'</span>';
            }
        }
        return '';
    }
}


if (!function_exists('displayLensTypeNote')) {
    /**
     * Display a note for 'Single Vision' lens type.
     */
    function displayLensTypeNote($lensType)
    {
        // Return empty string if $lensType is invalid or null
        if (!$lensType || !is_string($lensType)) {
            return '';
        }
        // Check if lens_type contains 'Single Vision' (case-insensitive)
        if (stripos($lensType, 'Single Vision Surfaced Conventional') !== false) {
            return '<div style="font-size: 10px !important; color: #000000; margin-top: 2px;">Use SV Stock if possible</div>';
        }
        return '';
    }
}

if (! function_exists('active_class')) {
    /**
     * Return active class if condition is true.
     *
     * @param bool $condition
     * @param string $class
     * @return string
     */
    function active_class($condition, $class = 'active')
    {
        return $condition ? $class : '';
    }
}

if (! function_exists('getLabzillaAccountConfig')) {
    /**
     * Get Labzilla account configuration from storage.
     *
     * @return array
     */
    function getLabzillaAccountConfig()
    {
        $config = [];
        if (Storage::exists('labzilla-account.txt')) {
            $config = json_decode(Storage::get('labzilla-account.txt'), true);
        }
        return $config;
    }
}