<?php

if (! function_exists('camelcase_to_word')) {
    /**
     * @param $str
     *
     * @return string
     */
    function camelcase_to_word($str)
    {
        return implode(' ', preg_split('/
          (?<=[a-z])
          (?=[A-Z])
        | (?<=[A-Z])
          (?=[A-Z][a-z])
        /x', $str));
    }
}
if (! function_exists('get_content_by_level')) {
    function get_content_by_level($payloads)
    {
        $allCategories = [];
        $user = auth()->user();
        foreach ($payloads as $key => $value) {
            if($value['name'] == '(Archive)'){
                continue;
            }

            $allCategories[$key] = [
                // 'id'    =>  $key,
                'text'    =>  $value['name'],
                'icon'    =>  'fa fa-folder',
                'children'    =>  false,
                'state'    =>  'closed',
            ];
            if($value['is_child']){
                $entries = $value['entries'];
                array_multisort( array_column($entries, "name"), SORT_DESC, $entries );
                foreach ($entries as $key2 => $value2) {
                    if(count($value2['entries']) > 0){
                        $allCategories[$key]['children'][$key2] = [
                            // 'id'    =>  $key2,
                            'text'    =>  $value2['name'],
                            'icon'    =>  'fa fa-folder',
                            'children'    =>  false,
                            'state'    =>  'closed',
                        ];
                        foreach ($value2['entries'] as $key3 => $value3) {
                            $filename = pathinfo($value3['name'], PATHINFO_FILENAME);
                            if($filename == $user->ac_code){
                                $allCategories[$key]['children'][$key2]['children'][] = [
                                    // 'id'    =>  $key3,
                                    'text'    =>  $value3['name'],
                                    'icon'    =>  'fa fa-file-pdf-o',
                                    'children'    =>  false,
                                    'state'    =>  'closed',
                                    'data'   =>  [
                                        // 'url'   =>  url('storage/app/public/statements/'.$value3['url']),
                                        'path'  =>  $value3['path'],
                                        'is_file'   =>  true
                                    ]
                                ];
                                break;
                            }
                        }
                    }else{
                        $filename = str_replace('.pdf', '', $value2['name']);
                        if($filename == $user->ac_code){
                            $allCategories[$key]['children'][] = [
                                // 'id'    =>  $key2,
                                'text'    =>  $value2['name'],
                                'icon'    =>  'fa fa-file-pdf-o',
                                'children'    =>  false,
                                'state'    =>  'closed',
                                'data'   =>  [
                                    // 'url'   =>  url('storage/app/public/statements/'.$value3['url']),
                                    'path'  =>  '/ls-hosting/monthly statements/'.$value['name'].'/'.$value2['name'],
                                    'is_file'   =>  true
                                ]
                            ];
                        }
                    }
                }
            }
        }

        // echo "<pre>";
        // print_r($allCategories);exit;
        return $allCategories;
    }
}
