<?php

namespace App\Http\Controllers\Backend\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Backend\ApiClient;
use Illuminate\Support\Str;

class ApiClientController extends Controller
{
    /**
     * Display a listing of the resource.
     * 
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return view('backend.auth.api-client.index')
            ->withModel(ApiClient::all());
    }

    /**
     * Show the form for creating a new resource.
     * 
     * @param Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        return view('backend.auth.api-client.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'rate_limit' => 'required|integer|min:1',
        ]);

        $token = Str::random(60);

        $client = ApiClient::create([
            'name' => $request->name,
            'token' => $token,
            'rate_limit' => $request->rate_limit,
            'active' => $request->has('active') ? 1 : 0,
        ]);
        if ($client){
            return redirect()->route('admin.auth.api-client.index')->withFlashSuccess(__('Api key is created successfully'));
        } else {
            throw new GeneralException(__('Api key is not created'));
        }
    }
    
    /**
     * Display the specified resource.
     *
     * @param  Request  $request
     * @param  ApiClient  $template
     * 
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, ApiClient $template)
    {

        return redirect()->route('admin.auth.api-client.index')->withFlashSuccess(__('Api key was deleted successfully'));
        if ($request->ajax()) {
            return view('backend.auth.api-client.includes.show-template')
                ->withMessage(ApiClient::find($request->id));            
        } else {
            return view('backend.auth.api-client.show')
            ->withTemplate($template);
        }
    }

    /**
     * Show the form for editing the specified resource.
     * 
     * @param  Request  $request
     * @param  ApiClient  $template
     * 
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request, ApiClient $apiClient)
    {
        return view('backend.auth.api-client.edit')
            ->withApiClient($apiClient);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  ApiClient  $template
     * @return mixed
     */
    public function update(Request $request, ApiClient $apiClient)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'rate_limit' => 'required|integer|min:1',
        ]);
        
        $params = [
            'name' => $request->name,
            'rate_limit' => $request->rate_limit,
            'active' => $request->active ? 1 : 0,
        ];
        if($request->regenerate_token){
            $params['token'] = Str::random(60);
        }
        $apiClient->update($params);
        return redirect()->route('admin.auth.api-client.index')->withFlashSuccess(__('Api key was updated successfully'));
    }

    public function regenerateToken(Request $request, ApiClient $apiClient)
    {
        $apiClient->update(['token' => Str::random(60)]);
        return redirect()->back()->withFlashSuccess(__('API token regenerated'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Request  $request
     * @param  ApiClient  $template
     * 
     * @return mixed
     */
    public function destroy(Request $request, ApiClient $apiClient)
    {
        if ($apiClient->delete()){
            return redirect()->route('admin.auth.api-client.index')->withFlashSuccess(__('Api key was deleted successfully'));
        } else {
            throw new GeneralException(__('Something went wrong'));
        }
    }
}
