<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\NotificationsTrait;
use App\Models\Auth\User;
use App\Models\Backend\Notification;
use App\Models\Backend\PhoneLog;
use Illuminate\Http\Request;
use App\Helpers\General\PusherFactory;
use Twilio\Rest\Client;
use App\Models\Auth\Role;
use App\Services\TwillioFax;
use Illuminate\Support\Facades\DB;
use App\Models\Backend\UserProfile;
use App\Models\Backend\UserSettings;
use App\Models\Backend\CustomerLinkStaff;
use App\Models\Backend\UserDevices;
use App\Models\Backend\Order;

/**
 * Class DashboardController.
 */
class DashboardController extends Controller
{
    use NotificationsTrait;

    /**
     * Display the specified resource.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function detailsApi($id,$type)
    {
        $response = [
            'order' =>  ''
        ];
        $userModel = User::where('id',$id)->first();
        if(!empty($userModel)){
            switch ($type) {
                case 'users':
                    $phone = optional($userModel->profile)->phone;
                    $fax = optional($userModel->profile)->fax;
                    $response['order'] = view('backend.auth.user.show.tabs.overview')
                        ->withUser($userModel)
                        ->withProfile($userModel->profile)
                        ->withFormattedPhone($phone ? formatPhone($phone) : null)
                        ->withFormattedFax($fax ? formatPhone($fax) : null)
                        ->render();
                        break;
            }
        }
        return response()->json($response);
    }


    public function recentNotification(Request $request) 
    {
        $orderId = $request->action == 'update'  ? PhoneLog::find($request->orderId)->order->id  : $request->orderId;
        $notification = Notification::where('order_id', $orderId)
            // ->where('from', $request->userId)
            ->where('user_id', $request->userId)
            ->latest('created_at')
            ->with([
                'userProfile:user_id,business_name',
                'user:id,ac_code,first_name,last_name',
                'order',
                'phoneLog'
            ])
            ->first();

        if (!$notification) {
            return response()->json(['status' => 'error', 'message' => 'Notification not found'], 404);
        }

        $user = $notification->user ?? null;
        $userProfile = $notification->userProfile ?? null;
        $order = $notification->order ?? null;
        $phoneLog = $notification->phoneLog ?? null;
        $acCode = $user->ac_code ?? '';
        $businessName = $userProfile->business_name ?? '';
        $account = $businessName ? "$acCode - $businessName" : $acCode;
        $senderName = trim(($user->first_name ?? '') . ' ' . ($user->last_name ?? ''));
        $notificationIcon = $phoneLog ? ($phoneLog->type === 'reply' ? 'questions' : $phoneLog->type) : '';

        $createdAt = optional($notification->created_at)->timezone('America/Toronto');
        $updatedAt = optional($notification->updated_at)->timezone('America/Toronto');

        $response = [
            'id'            => $notification->id,
            // 'user_id'       => $notification->user_id == 1 ? $notification->to : $notification->from,
            'user_id'       => $request->portalType === 'customer' ? 1 : ($notification->user_id == 1 ? $notification->to : $notification->from),
            'order_id_method' => ($order->order_csv ? '' : $order->method) . ($order->order_csv ? $order->order_csv : $order->id),
            'order_id'      => $order->id ?? '',
            'plog_id'       => $notification->plog_id,
            'title'         => $notification->title ?? '',
            // 'from'          => $request->portalType == 'admin' ? $notification->to : $notification->from,
            // 'to'            => $request->portalType == 'admin' ? $notification->from : $notification->to,
            'from'          => $notification->from,
            'to'            => $notification->to,
            'has_read'      => $notification->has_read,
            'created_at'    => $createdAt ? $createdAt->format('d-M-Y h:i a') : null,
            'updated_at'    => $updatedAt ? $updatedAt->format('d-M-Y h:i a') : null,
            'account'       => $account,
            'sender_name'   => $senderName,
            'patient'       => $order->patient ?? '',
            'type'          => $notificationIcon,
            'description'   => $phoneLog->description ?? '',
            'type_icon'     => PhoneLog::getNotifyIcon($notificationIcon),
            'tray'          => $order->tray ?? '',
            'invoice_no'    => $order->invoice_no ?? '',
        ];

        // Trigger Pusher event
            PusherFactory::make()->trigger(
                'channel-admin',
                'notification',
                ['data' => ['status' => 'success', 'response' => $response]]
            );

        return response()->json(['status' => 'success', 'response' => $response]);
    }

    /**
     * @return \Illuminate\View\View
     */
    public function notifications(Request $request)
    {
        $data = $this->getNotificationsData($request);
        if ($request->ajax()) {
            return view('backend.notifications', $data);
        }
        return view('backend.notifications', $data);
    }
    /** Function to mark read/unread admin notification message */
    public function markNotification(Request $request)
    {
        try {

            $newState = $request->newState == 'read' ? 1 : 0;
            Notification::where('id', $request->UID)
            ->update([
                'has_read' => $newState,
                'updated_at' => now()
            ]);
            $message = $newState ? 'Mark as read successfully' : 'Mark as unread successfully';
            return response()->json(['status' => 'success', 'message' => $message]);

        } catch (\Throwable $th) {
            return response()->json(['status' => 'error', 'message' => 'Failed to update status. Try again later!']);
        }
    }
}
