<?php

namespace App\Http\Controllers\Frontend\Auth;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
use Validator;
use App\Http\Controllers\Controller;
use App\Custom\DropboxComponent;

/**
 * Class StatementsController.
 */
class StatementsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return View|RedirectResponse
     */
    public function index(Request $request): View|RedirectResponse
    {
        if (!auth()->user()->isStatementAccessible()) {
            return redirect()->route('frontend.user.orders')
                ->withFlashDanger(__('Invalid Access!'));
        }
        return view('frontend.statements.index');
    }

    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function dataApi(Request $request): JsonResponse
    {
        return response()->json(['status' => false, 'message' => 'Something went wrong']);
    }

    /**
     * @return JsonResponse
     */
    public function loadContentApi(Request $request): JsonResponse
    {
        if ($request->ajax()) {
            $path = storage_path('app/public/imports/statements.json');
            $statements = json_decode(file_get_contents($path), true);
            array_multisort(array_column($statements, "name"), SORT_DESC, $statements);
            $response = get_content_by_level($statements);
            return response()->json($response);
        }
    }

    /**
     * Get File.
     *
     * @return string
     */
    public function file(Request $request): string
    {
        $contents = DropboxComponent::syncDrpboxFiles('', $request->get('id'), false);
        file_put_contents(storage_path('app/public/statements/') . $request->get('name'), $contents);
        $name = str_replace('.pdf', '', $request->get('name'));
        return route('frontend.files.statements', custom_encode_hashids($name, 'statements'));
    }
}