<?php

namespace App\Http\Controllers\Frontend\Auth;

use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdatePasswordRequest;
use Illuminate\Support\Facades\Auth;

/**
 * Class UpdatePasswordController.
 */
class UpdatePasswordController extends Controller
{
    /**
     * @var UserRepository
     */
    protected UserRepository $userRepository;

    /**
     * ChangePasswordController constructor.
     *
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @param UpdatePasswordRequest $request
     *
     * @throws \App\Exceptions\GeneralException
     * @return RedirectResponse
     */
    public function update(UpdatePasswordRequest $request): RedirectResponse
    {
        try {
            $this->userRepository->updatePassword($request->all());
        } catch (\Throwable $th) {
            return redirect()->route('frontend.user.account', '#change-password')->withFlashDanger($th->getMessage());
        }
        $user = Auth::user();
        $user->is_temp_pass = 0;
        $user->save();
        return redirect()->route('frontend.user.account', '#change-password')->withFlashSuccess(__('strings.frontend.user.password_updated'));
    }
}