<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use App\Models\Auth\User;
use App\Models\Backend\Order;

/**
 * Class FilesController.
 */
class FilesController extends Controller
{
    public function statements(Request $request, string $id): Response
    {
        $name = custom_decode_hashids($id, 'statements');
        $code = auth()->user()->getCustomerAdmin()->ac_code;
        if ($code == $name || auth()->user()->isAdmin()) {
            $path = Storage::disk('public')->path('statements/' . $name . '.pdf');

            if (!file_exists($path)) {
                abort(404);
            }

            return response()->file($path, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="' . $name . '"',
            ]);
        }

        abort(404);
    }

    public function invoice(Request $request, string $id): \Symfony\Component\HttpFoundation\Response
    {
        $parts = explode('LS-Invoice-', $id);
        $name = str_replace('.pdf', '', $parts[1]);
        $order = Order::where('user_id', auth()->user()->getCustomerAdmin()->id)->where('invoice_no', $name)->first();
        if (!empty($order) || auth()->user()->isAdmin() || auth()->user()->isLabManager() || auth()->user()->isLabStaff()) {
            $path = Storage::disk('public')->path('invoices/LS-Invoice-' . $name . '.pdf');
            if (!file_exists($path)) {
                abort(404);
            }
            $filename = 'LS-Invoice-' . $name . '.pdf';
            return response()->file($path, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="' . $filename . '"',
            ]);
        }

        abort(404);
    }

    public function creditMemos(Request $request, string $id): Response
    {
        $name = custom_decode_hashids($id, 'credit-memos');
        if (true) { // Assuming authorization check is handled elsewhere or always allow
            $path = Storage::disk('public')->path('credit-memos/' . $name . '.pdf');

            if (!file_exists($path)) {
                abort(404);
            }

            return response()->file($path, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="' . $name . '"',
            ]);
        }

        abort(404);
    }

    public function others(Request $request, string $id): Response
    {
        $name = custom_decode_path($id, 'others');
        if ($name) {
            $path = Storage::disk('public')->path($name);

            if (!file_exists($path)) {
                abort(404, 'File not found.');
            }

            return response()->file($path, [
                'Content-Type' => 'application/pdf',
                'Content-Disposition' => 'inline; filename="' . $name . '"',
            ]);
        }

        abort(404, 'Invalid file.');
    }

    public function orders(Request $request, string $id): Response
    {
        $name = $id;
        if ($name) {
            $path = Storage::disk('public')->path('order-files/' . $name);

            if (!file_exists($path)) {
                $orderId = str_replace(['order-', '.pdf'], '', $name);
                $order = Order::find($orderId);
                if ($order) {
                    $order->uploadPDFToDropbox();
                    if (!file_exists($path)) {
                        abort(404, 'File not found.');
                    }
                } else {
                    abort(404, 'File not found.');
                }
            }

            return response()->file($path)->header('Content-Type', 'application/pdf');
        }

        abort(404, 'Invalid file.');
    }
}