<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use App\Models\Auth\User;

/**
 * Class PushNotificationsController.
 */
class PushNotificationsController extends Controller
{
    public function index(): View
    {
        return view('home');
    }

    public function storeToken(Request $request): JsonResponse
    {
        auth()->user()->updateDevices($request->token);
        return response()->json(['Token successfully stored.']);
    }

    public function test(Request $request): JsonResponse
    {
        auth()->user()->sendWebNotifications([
            'title' => 'test',
            'body' => 'test',
            'data' => [
                'type' => 'comments'
            ]
        ]);

        return response()->json(['Notification sent.']);
    }
}