<?php

namespace App\Http\Controllers\Frontend\User;

use App\Models\Backend\Order;
use App\Models\Backend\UserProfile;
use App\Models\Auth\User;
use App\Models\Backend\UserSettings;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\NotificationsTrait;
use Illuminate\Http\Request;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Models\Backend\Notification;
use App\Models\Backend\PhoneLog;

/**
 * Class AccountController.
 */
class AccountController extends Controller
{
    use NotificationsTrait;

    /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * UserController constructor.
     *
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $user = auth()->user();

        // Get last five latest orders and show on admin profile page
        $orders = Order::orderBy('id', 'desc')->where('user_id', $user->id)->take(5)
            ->get();

        $profile = $user->profile ?? new UserProfile();

        $settings = $user->userSettings ?? new UserSettings();
        if (!$user->userSettings) {
            $settings->send_to = 'email';
        }

        $pageCount = config('access.page_size');
        if ($request->filled('page-no')) {
            $pageCount = $request->get('page-no') + $pageCount;
        }

        $users = $this->userRepository->getActivePaginated($pageCount, 'id', 'asc');
        if ($request->ajax()) {
            return view('partials.user-table')->withUsers($users)->withPageCount($pageCount);
        }
        return view('frontend.user.account')
            ->withUser($user)
            ->withOrders($orders)
            ->withProfile($profile)
            ->withSettings($settings)
            ->withUsers($users)
            ->withPageCount($pageCount);
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function usersTab(Request $request)
    {
        $pageCount = config('access.page_size');
        if ($request->filled('page-no')) {
            $pageCount = $request->get('page-no') + $pageCount;
        }

        $users = $this->userRepository->getActivePaginated($pageCount, 'id', 'asc');

        return view('frontend.user.account.tabs.users')
            ->withUsers($users)
            ->withPageCount($pageCount);
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function notifications(Request $request)
    {
        $data = $this->getNotificationsData($request);
        if ($request->ajax()) {
            return view('frontend.user.notifications', $data);
        }
        return view('frontend.user.notifications', $data);
    }
}