<?php

namespace App\Http\Controllers\Traits;

use Illuminate\Http\Request;
use App\Models\Backend\Notification;

trait NotificationsTrait
{
    /**
     * Get notifications data for both frontend and backend.
     *
     * @param Request $request
     * @return array
     */
    protected function getNotificationsData(Request $request)
    {
        $to = auth()->user()->isAdmin() ? 1 : auth()->user()->getCustomerAdmin()->id;

        $notifications = Notification::where('to', $to)
            ->with([
                'userProfile:user_id,business_name',
                'user:id,ac_code,first_name,last_name',
                'order:id,order_csv,method,patient,tray,invoice_no',
                'phoneLog:id,user_id,order_id,type,description,replied',
                'phoneLog.user:id,first_name,last_name',
            ])
            ->orderByRaw('has_read ASC, created_at DESC')
            ->paginate(100);

        $response = $notifications->map(function ($notification) {
            $adminName = optional($notification->phoneLog->user)->first_name . ' ' .
                optional($notification->phoneLog->user)->last_name;

            // Format dates (now handled more safely)
            $createdAt = optional($notification->created_at)->timezone('America/Toronto');
            $updatedAt = optional($notification->updated_at)->timezone('America/Toronto');
            return [
                'id'            => $notification->id,
                'user_id'       => $notification->user_id,
                'order_id_method' => ($notification->order->order_csv ?? false) ? ($notification->order->order_csv) : (($notification->order->method ?? '') . ($notification->order->id ?? '')),
                'order_id'      => $notification->order->id ?? '',
                'plog_id'       => $notification->plog_id,
                'title'         => $notification->title ?? '',
                'from'          => $notification->from,
                'to'            => $notification->to,
                'has_read'      => $notification->has_read,
                'created_at'    => $createdAt ? $createdAt->format('d-M-Y h:i a') : null,
                'updated_at'    => $updatedAt ? $updatedAt->format('d-M-Y h:i a') : null,
                'account'       => ($notification->user->ac_code ?? '') . ' ' . ($notification->userProfile->business_name ?? ''),
                'sender_name'   => $adminName,
                'patient'       => $notification->order->patient ?? '',
                'type'          => $notification->phoneLog ? ($notification->phoneLog->type === 'reply' ? 'questions' : $notification->phoneLog->type) : '',
                'description'   => $notification->phoneLog->description ?? '',
                'tray'          => $notification->order->tray ?? '',
                'invoice_no'    => $notification->order->invoice_no ?? '',
            ];
        });

        return ['notifications' => $notifications, 'response' => $response];
    }
}