<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Backend\ApiClient;
use Illuminate\Http\JsonResponse;

class ApiClientAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->header('X-API-Token');

        if (!$token) {
            return response()->json([
                'success' => false,
                'message' => 'API token is required'
            ], 401);
        }

        $apiClient = ApiClient::where('token', $token)
            ->where('active', true)
            ->first();

        if (!$apiClient) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid or inactive API token'
            ], 401);
        }

        // Update last used timestamp
        $apiClient->update(['last_used_at' => now()]);

        // Add API client to request for use in controllers
        $request->merge(['api_client' => $apiClient]);

        return $next($request);
    }
} 