<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class CustomerAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if (Auth::user()->can('view frontend')){
            $routeName = Route::currentRouteName();
            if(Auth::user()->isTempPass() && $routeName != 'frontend.user.account'){
                return redirect()->route('frontend.user.account','#change-password');
            }
            return $next($request);
        }
        return back()->with('error','You are unauthorized for this action');
    }
}
