<?php

namespace App\Http\Requests\Backend\Auth;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class StoreEmailTemplateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->user()->isAcessible(['view backend']);

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'title' => 'required|unique:email_templates|max:191',
            'description' => 'required',
            // 'response_ok' => 'required|max:191',
            // 'response_no' => 'required|max:191',
            'subject' => 'required',
        ];
    }
}
