<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use LangleyFoxall\LaravelNISTPasswordRules\PasswordRules;
use App\Models\Auth\Role;

/**
 * Class StoreUserRequest.
 */
class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->isAcessible(['backend admin']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'first_name'    =>  ['required', 'max:191'],
            'last_name'     =>  ['required', 'max:191'],
            'email'         =>  ['required', 'email', 'max:191', Rule::unique('users')],
            'password'      =>  ['required','min:6','confirmed'],//PasswordRules::register($this->request->get('email')),
            'roles'         =>  ['required', 'exists:roles,id'],
        ];

        if($this->request->get('roles') == Role::findByType(config('access.users.customer_admin'))->id){
            $rules['business_name'] = ['required','max:191'];
            $rules['ac_code'] = ['required',Rule::unique('users')];
        }

        return $rules;
    }
}
