<?php

namespace App\Http\Requests\Frontend\User;

use App\Models\Auth\Role;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use LangleyFoxall\LaravelNISTPasswordRules\PasswordRules;

/**
 * Class StoreUserRequest.
 */
class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->isAcessible(['frontend admin']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->roles == Role::findByType(config('access.users.customer_staff'))->id) {
            return [
                'first_name' => ['required', 'max:191'],
                'last_name' => ['required', 'max:191'],
                'password' => ['required','min:6','confirmed'],//PasswordRules::register($this->email)
            ];
        } else {
            return [
                'first_name' => ['required', 'max:191'],
                'last_name' => ['required', 'max:191'],
                'email' => ['required', 'email', 'max:191', Rule::unique('users')],
                'password' => ['required','min:6','confirmed'],//PasswordRules::register($this->email)
            ];
        }
    }
}
