<?php

namespace App\Listeners\Frontend\Auth;

use App\Models\Auth\User;
use App\Models\Backend\Order;
use Illuminate\Support\Facades\Mail;
use App\Models\Backend\EmailTemplate;
use App\Mail\Frontend\CustomerReplyMail;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Events\Frontend\Auth\CustomerReplied;

class CustomerRepliedListner implements ShouldQueue
{ 
    /**
     * @var
     */
    protected $email;

    /**
     * @var
     */
    protected $message;

    /**
     * @var
     */
    protected $order;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    private function getMessage($message) {
        $message = str_replace("<p>","",$message);
        $message = str_replace("</p>","",$message);
        $message = str_replace("{!firstName!}",$this->order->user->first_name,$message);
        $message = str_replace("{!lastName!}",$this->order->user->last_name,$message);
        $message = str_replace("{!order_id!}","Oredr # ".$this->order->id,$message);
        $message = str_replace("&nbsp;"," ",$message);

        return $message;
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\Frontend\Auth\CustomerInquiryLog  $event
     * @return void
     */
    public function handle(CustomerReplied $event)
    {
        $reply          =  (object) $event->reply;
        $message        =  EmailTemplate::find($reply->temp_id)->description;
        $this->order    =  Order::find($reply->order_id);
        $this->email    =  User::find($reply->to)->email;
        $this->message  =  $this->getMessage($message);
        
        Mail::to($this->email)->send(new CustomerReplyMail($reply->response,$this->message));
    }
}