<?php

namespace App\Mail\Frontend;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class CustomerInquiry extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The order instance.
     *
     * @var PhoneLogs
     */
    protected $logs;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($logs)
    {
        $this->logs = $logs;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.customer-inquiry')
            ->with([
                'description' => $this->logs->description,
                'order_no' => $this->logs->order_id !== null ? $this->logs->order_id : null
            ]);
    }
}
