<?php

namespace App\Models\Auth\Traits\Attribute;

use Illuminate\Support\Facades\Hash;

/**
 * Trait UserAttribute.
 */
trait EmailTemplateAttribute
{
    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '
            <a href="'.route('admin.auth.template.destroy', $this).'"
            data-method="delete"
            data-trans-button-cancel="'.__('buttons.general.cancel').'"
            data-trans-button-confirm="'.__('buttons.general.crud.delete').'"
            data-trans-title="'.__('strings.backend.general.are_you_sure').'"
            class="btn btn-sm dropdown-item"><i class="fa fa-trash-o" aria-hidden="true"></i>   '.__('buttons.general.crud.delete').'</a> ';
    }

    /**
     * @return string
     */
    public function getShowButtonAttribute()
    {
        return '<a href="'.route('admin.auth.template.show', $this).'" data-toggle="tooltip" data-placement="top" title="'.__('buttons.general.crud.view').'" class="btn blue btn-xs"><i class="fa fa-eye"></i></a>';
    }

    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="'.route('admin.auth.template.edit', $this).'" title="'.__('buttons.general.crud.edit').'" class="btn btn-xs btn-primary"><i class="fa fa-edit"></i></a>';
    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return'<div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">  
        '.$this->edit_button.'
                <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false" style="display:none;"> 
                    '.__('labels.general.more').'
                    <i class="fa fa-angle-down"></i>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        '.$this->delete_button.'
                    </li>
                </ul>
        </div>';
    }
}