<?php

namespace App\Models\Auth\Traits\Attribute;

use Illuminate\Support\Facades\Hash;
use App\Models\Backend\OrderStatus;

/**
 * Trait UserAttribute.
 */
trait OrderAttribute
{
    /**
     * @return string
     */
    public function getTypeLabelAttribute()
    {
        switch ($this->type) {
            case self::ORDER_RX:
                 return '<span class="badge bg-primary">'.ucwords($this->type).'</span>';
                // return '<span class="label">' . svg_image('order-type-rx.svg', 'svg-icons-order', 'Rx') . '</span>';
            case self::ORDER_CONSUMABLE:
                return '<span class="badge bg-info">'.ucwords($this->type).'</span>';
                // return '<span class="label">' . svg_image('order-type-consumable.svg', 'svg-icons-order', 'Consumable') . '</span>';
            case self::ORDER_STOCK:
                return '<span class="badge bg-danger">'.ucwords($this->type).'</span>';
                // return '<span class="label">' . svg_image('order-type-stock.svg', 'svg-icons-order', 'Stock') . '</span>';
            default:
                return '';
        }
    }

     /**
     * @return string
     */
    public function getTrakingStatus($date = true)
    {
        if(!empty($this->statusModel)){
            $html = '';
            if(!empty($this->tracking_no)){
                $html = '<div class="order-status">
                    <div class="status-dot" style="background-color:'.$this->statusModel->color.'"></div>
                    <span id="statusText">'.$this->statusModel->title.'</span>';
                    // <span id="statusText">'.$this->statusModel->title.'<i class="fa fa-arrow-up" aria-hidden="true"></i></span>';
                if($date){
                    if(!empty($this->status_date_time)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->status_date_time,'d-M-Y h:i a').'</span>';
                    }
                    elseif(!empty($this->shipped_date)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->shipped_date,'d-M-Y h:i a').'</span>';
                    }
                }
                $html .= '</div>';
            }elseif(!empty($this->status_date_time)){
                $html = '<div class="order-status">
                            <span class="status-dot" style="background-color:'.$this->statusModel->color.'"></span>
                            <span id="statusText">'.$this->statusModel->title.'</span>';
                            
                    if($date){
                        $html .= ' <span class="ship-date">'.date_time_format($this->status_date_time,'d-M-Y h:i a').'</span>';
                    }
                $html .=  '</div>';
            }elseif($this->isReceivedAt()){
                $html = '<div class="order-status">
                                <span class="status-dot" style="background-color:'.$this->statusModel->color.'"></span>
                                <span id="statusText">'.$this->statusModel->title.'</span>';
                            
                    if(!empty($this->received_at_lab_date)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->received_at_lab_date,'d-M-Y h:i a').'</span>';
                    }
                $html .=  '</div>';
            }
            else{
                $html = '<div class="order-status">
                        <div class="status-dot" style="background-color:'.$this->statusModel->color.'"></div>
                        <span id="statusText">'.$this->statusModel->title.'</span>
                </div>';
            }

            return $html;
        }
        return 'Not Set';
    }

    /**
     * @return string
     */
    public function getStatusLabelAttribute($date = true)
    {
        if(!empty($this->statusModel)){
            $html = '';
            if(!empty($this->tracking_no)){
                $html = '<span class="label label-sm label-primary label-outlined orders_shipped" style="border-color: '.$this->statusModel->color.';color:'.$this->statusModel->color.';" tracking_no="'.$this->tracking_no.'" data-ship-type="'.$this->shipping_carrier.'">'.$this->statusModel->title.' <i class="fa fa-arrow-up" aria-hidden="true"></i></span>';

                $html = '<div class="order-status orders_shipped"  data-ship-type="'.$this->shipping_carrier.'" tracking_no="'.$this->tracking_no.'">
                    <div class="status-dot" style="background-color:'.$this->statusModel->color.'"></div>
                    <span id="statusText">'.$this->statusModel->title.'<i class="fa fa-arrow-up" aria-hidden="true"></i></span>';
                if($date){
                    if(!empty($this->status_date_time)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->status_date_time,'d-M-Y h:i a').'</span>';
                    }
                    elseif(!empty($this->shipped_date)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->shipped_date,'d-M-Y h:i a').'</span>';
                    }
                }
                $html .= '</div>';
            }elseif(!empty($this->status_date_time)){
                // $html = '<span class="label label-sm label-primary label-outlined" style="border-color: '.$this->statusModel->color.';color:'.$this->statusModel->color.';">'.$this->statusModel->title.'</span>';
                $html = '<div class="order-status">
                                <span class="status-dot" style="background-color:'.$this->statusModel->color.'"></span>
                                <span id="statusText">'.$this->statusModel->title.'</span>';
                            
                    if($date){
                        $html .= ' <span class="ship-date">'.date_time_format($this->status_date_time,'d-M-Y h:i a').'</span>';
                    }
                $html .=  '</div>';
            }elseif($this->isReceivedAt()){
                $html = '<div class="order-status">
                                <span class="status-dot" style="background-color:'.$this->statusModel->color.'"></span>
                                <span id="statusText">'.$this->statusModel->title.'</span>';
                            
                    if(!empty($this->received_at_lab_date)){
                        $html .= ' <span class="ship-date">'.date_time_format($this->received_at_lab_date,'d-M-Y h:i a').'</span>';
                    }
                $html .=  '</div>';
            }
            else{
                $html = '<div class="order-status">
                        <div class="status-dot" style="background-color:'.$this->statusModel->color.'"></div>
                        <span id="statusText">'.$this->statusModel->title.'</span>
                </div>';
                // $html = '<span class="label label-sm label-primary label-outlined" style="border-color: '.$this->statusModel->color.';color:'.$this->statusModel->color.';">'.$this->statusModel->title.'</span>';
                // if($date){
                //     // $html .= ' <span class="ship-date">'.date('d-M-Y h:i a',strtotime($this->created_at)).'</span>';
                //     $html .= ' <span class="ship-date">'.date_time_format($this->created_at,'d-M-Y h:i a').'</span>';
                // }
            }

            return $html;
        }
        return 'Not Set';
    }

    /**
     * @return string
     */
    public function getStatusFgLabelAttribute()
    {
        return (!empty($this->statusModel)) ? '<span class="badge bg-danger" style="color:'.$this->statusModel->color.';">'.$this->statusModel->title.'</span>' : 'Not Set';
    }

    /**
     * @return string
     */
    public function getPriceLabelAttribute()
    {
        return '<span class="badge bg-info">$'.$this->price.'</span>';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        if($this->status != OrderStatus::getId(OrderStatus::STATUS_SAVED))
            return '';
        return '
            <a href="'.route('frontend.user.destroy', $this).'"
            data-method="delete"
            data-trans-button-cancel="'.__('buttons.general.cancel').'"
            data-trans-button-confirm="'.__('buttons.general.crud.delete').'"
            data-trans-title="'.__('strings.backend.general.are_you_sure').'"
            class="btn btn-sm dropdown-item"><i class="fa fa-trash-o" aria-hidden="true"></i>   '.__('buttons.general.crud.delete').'</a> ';
    }

    /**
     * @return string
     */
    public function getShowButtonAttribute()
    {
        if (auth()->user()->isAdmin()) {
            return '<a href="'.route('admin.order.show', $this).'" data-bs-toggle="tooltip" data-bs-placement="top" title="'.__('buttons.general.crud.view').'" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>';
        }
        return '<a href="'.route('frontend.user.orders.show', $this).'" data-bs-toggle="tooltip" data-bs-placement="top" title="'.__('buttons.general.crud.view').'" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>';
    }

    /**
     * @return string
     */
    public function getRxCreateAnotherButtonAttribute()
    {
        if(auth()->user()->isCustomerAdmin()){
            return '<li>
                    <a href="javascript:void(0);" class="btn btn-sm dropdown-item sbold rx_create_another" data-id='.$this->id.'><i class="fa fa-copy" aria-hidden="true"></i> Copy</a>
                </li>';
        }
    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        if (auth()->user()->isAdmin()) {
            return'<div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">
                '.$this->show_button.'
                <button class="btn btn-sm btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                    '.__('labels.general.more').'
                    <i class="fa fa-angle-down"></i>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        <a href="#stack1" class="btn btn-sm dropdown-item sbold add_comment" data-id='.$this->id.' data-attr="orders" data-bs-toggle="modal"><i class="fa fa-commenting" aria-hidden="true"></i>Comments</a>
                    </li>
                    <li>
                        <a href="#templates_modal" class="btn btn-sm dropdown-item sbold get_email_templates" data-id='.$this->id.' data-bs-toggle="modal"><i class="fa fa-envelope" aria-hidden="true"></i>'.__('labels.backend.access.emails.email_templates').'</a>
                    </li>
                </ul>
        </div>';
        } else {
            return'<div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">
                '.$this->show_button.'
                <button class="btn btn-sm btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                    '.__('labels.general.more').'
                    <i class="fa fa-angle-down"></i>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        <a href="#stack1" class="btn btn-sm dropdown-item sbold add_comment" data-id='.$this->id.' data-attr="orders" data-bs-toggle="modal"><i class="fa fa-commenting" aria-hidden="true"></i>Comments</a>
                    </li>
                    '.$this->rx_create_another_button.'
                </ul>
        </div>';
        }
    }
}
