<?php

namespace App\Models\Auth\Traits\Method;

/**
 * Trait RoleMethod.
 */
trait RoleMethod
{
    /**
     * @return mixed
     */
    public function isAdmin()
    {
        return $this->name === config('access.users.admin_role');
    }

    /**
     * @return string
     */
    public function admin() {
        return config('access.users.admin_role');
    }

    /**
     * @return string
     */
    public function labManager() {
        return config('access.users.lab_manager');
    }

    /**
     * @return string
     */
    public function labStaff() {
        return config('access.users.lab_staff');
    }

    /**
     * @return string
     */
    public function customerAdmin() {
        return config('access.users.customer_admin');
    }

    /**
     * @return string
     */
    public function customerStaff() {
        return config('access.users.customer_staff');
    }   

    public static function findByType($type){
        return self::where('name',$type)->first();
    } 
}
