<?php

namespace App\Models\Auth\Traits\Relationship;

use App\Models\Backend\Order;
use App\Models\Auth\SocialAccount;
use App\Models\Backend\UserProfile;
use App\Models\Auth\PasswordHistory;
use App\Models\Backend\Notification;
use App\Models\Backend\CustomerLinkStaff;

/**
 * Class UserRelationship.
 */
trait UserRelationship
{

    /**
     * @return mixed
     */
    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    /**
     * @return mixed
     */
    public function providers()
    {
        return $this->hasMany(SocialAccount::class);
    }

    /**
     * @return mixed
     */
    public function passwordHistories()
    {
        return $this->hasMany(PasswordHistory::class);
    }

    /**
     * @return mixed
     */
    public function profile() {
        return $this->hasOne(UserProfile::class);
    }

    /**
    * @return mixed
    */
    public function staff() {
        return $this->belongsTo(CustomerLinkStaff::class);
    }

    /**
    * @return mixed
    */
    // public function notifications() {
    //     return $this->hasMany(Notification::class,'to');
    // }
}
