<?php

namespace App\Models\Auth;

use Validator;
use Illuminate\Http\Request;
use App\Models\Backend\Notification;
use Spatie\Permission\Traits\HasRoles;
use App\Models\Auth\Traits\Scope\UserScope;
use App\Models\Auth\Traits\Method\UserMethod;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\Traits\Attribute\UserAttribute;
use App\Models\Auth\Traits\Relationship\UserRelationship;

/**
 * Class User.
 */
class User extends BaseUser
{
    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;
    
    use UserAttribute,
        UserMethod,
        UserRelationship,
        UserScope,
        HasRoles;

    protected $appends = ['business_name', 'full_name'];
    public function getBusinessNameAttribute()
    {
        return $this->profile ? $this->profile->business_name : null;
    }
}
