<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;

class AppSettings extends Model
{
	public $timestamps      = false;
    public $table           = 'app_settings';
    const DEFAULT_HOW_TO_START_VIDEO   = 'how_to_start_video';
    const DEFAULT_DASHBOARD_CONTENT   = 'dashboard_content';
    const LAST_UPDATE_ORDERS_TIME   = 'last_update_orders_time';
    const STOCK_CENTER_PRICE_FILE   = 'stock_center_price_file.pdf';

    protected $fillable     = ['settings_key','settings_value'];

    public static function findByKey($key){
        return self::where('settings_key',$key)->first()->settings_value;
    }
    public static function findByObj($key){
        return self::where('settings_key',$key)->first();
    }        

    public static function getFilePath($file){
        if(file_exists(storage_path('app/public/flyers/'.$file)))
            return url('storage/app/public/flyers/'.$file);

        return false;
    }

    public static function getAllFlyerImages(){
        $response = [];
        $mediaPath = storage_path('app/public/flyers/');
        \File::isDirectory($mediaPath) or \File::makeDirectory($mediaPath, 0777, true, true);
        $files = \File::allFiles($mediaPath);
        foreach ($files as $key => $value) {
            $file = pathinfo($value);
            $path = $file['dirname'].'/'.$file['basename'];
            if(file_exists($path)){
                $response[] = [
                    'name'  =>  $file['basename'],
                    'size'  =>  \File::size($path),
                    'path'  =>  self::getFilePath($file['basename'])
                ];
            }
        }
        return $response;
    }

    public static function removeFlyersImage($fileName){
        if(file_exists(storage_path('app/public/flyers/'.$fileName))){
            unlink(storage_path('app/public/flyers/'.$fileName));
            return true;
        }   
        return false;
    }

    public static function uploadFlyersImage($image){
        $response = [];
        if($image->move(storage_path('app/public/flyers/'),$image->getClientOriginalName(),['disk' => 'storage'])){
            $response[] = url('storage/app/public/flyers/'.$image->getClientOriginalName());
        }
        return $response;
    }

}

