<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;

class Cron extends Model
{
    protected $table = 'crons';

    protected $fillable = [
        'id',
        'command',
        'name',
        'description',
        'short_description',
        'last_scheduled',
        'next_scheduled',
        'status',
        'minute',
        'hour',
        'day',
        'month',
        'weekday',
        'logs',
        'created_at',
        'updated_at',
    ]; 

    protected function extractCronName($string) {
        if (preg_match("/'artisan' (.*)/", $string, $matches)) {
            return $matches[1];
        }
        return '';
    }
}
