<?php

namespace App\Models\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use App\Models\Auth\Traits\Attribute\EmailTemplateAttribute;


class EmailTemplate extends Model
{
    use EmailTemplateAttribute;

    protected $table = "email_templates";

    protected $fillable = [
        'id',
        'name',
        'title',
        'subject',
        'description',
        'response_ok',
        'response_no'
    ];

    /**
     * @param EmailTemplate $template
     *
     * @throws GeneralException
     * @throws \Exception
     * @throws \Throwable
     * @return bool
     */
    public function deleteTemplate(EmailTemplate $template) : bool
    {
        return DB::transaction(function () use ($template) {

            $template->delete();
            if ($template) {
                return true;
            } else {
                return false;
            }
        });
    }

    public function parseText($message,$order,$user) {
        $profile = $user->profile;
        $message = str_replace("<p>","",$message);
        $message = str_replace("</p>","",$message);
        $message = str_replace("{!firstName!}",$user->first_name,$message);
        $message = str_replace("{!lastName!}",$user->last_name,$message);
        $message = str_replace("{!order_id!}",$order->getOrderNumber(),$message);
        $message = str_replace("{!order_url!}",route('frontend.user.orders').'?order='.$order->id,$message);
        $message = str_replace("{!invoiceNumber!}",$order->invoice_no,$message);
        $message = str_replace("{!customerBusinessName!}",$user->getBusinessName(),$message);
        $message = str_replace("{!patientName!}",$order->patient,$message);
        if(!empty($profile)){
            $message = str_replace("{!businessAddress!}",$profile->address1,$message);
            $message = str_replace("{!phone!}",$profile->phone,$message);
            $message = str_replace("{!fax!}",$profile->fax,$message);
        }
        $message = str_replace("{!email!}",$user->email,$message);
        $message = str_replace("&nbsp;"," ",$message);

        return $message;
    }

    public function getSubject($order,$user){
        return $this->parseText($this->subject,$order,$user);
    }

    public function parseActualMessage($html,$message){
        return str_replace("{!actualMessage!}",$message,$html);
    }

    public function getDescription($order,$user){
        return $this->parseText($this->description,$order,$user);
    }
}