<?php

namespace App\Models\Backend;


use Illuminate\Http\Request;
use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;

class FrameManufacturer extends Model
{ 
    protected $table = "frame_manufacturers";

    protected $fillable = [
        'id',
        'manufacturer_id',
        'manufacturer_name',
        'market',
        'status',
        'updated_at',
        'created_at'
    ];

    public function frameStyles()
    {
        return $this->hasMany(FrameStyle::class, 'manufacturer_id', 'manufacturer_id');
    }
}
