<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;

class ImportedConsumablesOrder extends Model
{
    public $timestamps = false;

    protected $table = "imported_consumables_orders";

    const FILE_NAME = 'consumeables.csv';

    protected $fillable = [
        'id',
        'category',
        'sub_category',
        'upc',
        'name',
        'variant',
        'size_color',
        'unit',
        'sub_name',
        'price',
        'description',
        'min',
        'max',
        'image',
        'image_hover',
        'price_unit'
    ];

    /**
    * Function to import Rx Lens from csv using cron job.
    */ 
    public static function import() {
        $filename = storage_path('app/public/imports/'.self::FILE_NAME);
        
        // Open file with explicit encoding
        $handle = fopen($filename, "r");
        if (!$handle) {
            throw new \Exception("Could not open file: " . $filename);
        }
    
        // Skip BOM if present (common in UTF-8 files)
        $bom = "\xef\xbb\xbf";
        if (fgets($handle, 4) !== $bom) {
            // Rewind if no BOM found
            rewind($handle);
        }
    
        $first = true;
        $fields = [];
        
        while (($row = fgetcsv($handle, 4096)) !== false) {
            // Convert each value to UTF-8 encoding
            $row = array_map(function($value) {
                return mb_convert_encoding($value, 'UTF-8', 'UTF-8');
            }, $row);
    
            if (empty($fields)) {
                $fields = $row;
                continue;
            }
    
            $data = [
                'category'      => !empty($row[0]) ? trim($row[0]) : null,
                'sub_category'  => !empty($row[1]) ? trim($row[1]) : null,
                'upc'           => !empty($row[2]) ? trim($row[2]) : null,
                'name'          => !empty($row[3]) ? trim($row[3]) : null,
                'sub_name'      => !empty($row[4]) ? trim($row[4]) : null,
                'description'   => !empty($row[5]) ? trim($row[5]) : null,
                'unit'          => !empty($row[6]) ? trim($row[6]) : null,
                'price'         => !empty($row[7]) ? (float) str_replace(',', '.', $row[7]) : 0,
                'price_unit'    => !empty($row[8]) ? (float) str_replace(',', '.', $row[8]) : 0,
                'min'           => !empty($row[9]) ? (int)$row[9] : 0,
                'max'           => !empty($row[10]) ? (int)$row[10] : 0,
                'image'         => !empty($row[11]) ? trim($row[11]) : null,
                'image_hover'   => !empty($row[12]) ? trim($row[12]) : null,
            ];
    
            if ($first) {
                $first = false;
                self::truncate();
            }
    
            $existingRecord = self::where('name', $data['name'])->first();
            $data['variant'] = $existingRecord ? 1 : 0;
    
            try {
                self::create($data);
            } catch (\Exception $e) {
                // Log the error for debugging
                \Log::error("Failed to import row: " . json_encode($data) . " Error: " . $e->getMessage());
                continue; // Skip this row and continue with next
            }
        }
    
        fclose($handle);
        return true;
    }

  

    public static function uploadImages($images){
        $response = [];
        if(!empty($images)){
            foreach ($images as $photo) {
                if($photo->storeAs('public/imports/images',$photo->getClientOriginalName())){
                    $response[] = url('storage/app/public/imports/images'.$photo->getClientOriginalName());
                }
            }
        }
        return $response;
    }

    public static function uploadImage($image){
        $response = [];
        if($image->storeAs('public/imports/images',$image->getClientOriginalName())){
            $response[] = url('storage/app/public/imports/images'.$image->getClientOriginalName());
        }
        return $response;
    }

    public static function removeImage($fileName){
        if(file_exists(storage_path('app/public/imports/images/'.$fileName))){
            unlink(storage_path('app/public/imports/images/'.$fileName));
            return true;
        }   
        return false;
    }

    public function getImage(){
        $path = storage_path('app/public/imports/images/'.$this->image);
        if(file_exists($path))
            return url('storage/app/public/imports/images/'.$this->image);

        return url('public/img/test/blue-pads.jpg');
    }
}
