<?php

namespace App\Models\Backend;

use DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Models\Backend\Order;

class OrderStatus extends Model
{
    const STATUS_SUBMITTED = 'submitted';
    const STATUS_SAVED = 'saved';
    const STATUS_SHIPPED = 'shipped';
    const STATUS_RECEIVED_AT_LAB = 'received_at_lab';
    protected $table = "order_status";

    public $timestamps      = false;
    protected $fillable = [
        'id',
        'name',
        'title',
        'color',
        'sorting',
        'active'
    ];


    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public static function getAll(){
        return self::where('active','1')->orderBy('sorting', 'asc')->get();
    }

    public static function getCustomerOrderStatus(){
        $response = [];
        $order = Order::where('user_id', Auth::id())->select('status')->groupBy('status')->get();
        foreach($order as $key => $value)
        $response[] =  self::where('active','1')->where('id', $value['status'])->orderBy('sorting', 'asc')->get();
        return $response;
    }

    public function isShipped(){
        return $this->name == OrderStatus::STATUS_SHIPPED ? true : false;
    }

    public static function getStatus($type){
        $model = self::where('name',$type)->first();
        
        if(!empty($model))
            return $model;

        return self::first();
    }

    public static function getStatusByTitle($title){
        return self::whereRaw( 'LOWER(`title`) like ?', [ $title ] )->first();
    }

    public static function getId($type){
        $model = self::where('name',$type)->first();
        
        if(!empty($model))
            return $model->id;

        return self::first()->id;
    }

    public static function sync($name){
        if(!empty($name)){
            $model = self::where('title',$name)->first();
        
            if(empty($model)){
                self::create([
                    'name'  =>  str_replace(' ', '_', $name),
                    'title'  =>  $name,
                ]);
            }
        }
    }
}
