<?php

namespace App\Models\Backend;

use DB;
use App\Models\Backend\StockOrder;
use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;

class ScheduledCrons extends Model
{
    protected $table = "scheduled_crons";

    protected $fillable = [
        'type',
        'details',
        'active'
    ];

    public static function add($type,$details){
        $data = self::where('type',$type)->first();
        if(empty($data)){
            $data =  self::create([
                'type'  =>  $type,
                'details'   =>  $details,
                'active'    =>  0
            ]);
        }
        return $data;
    }

    public static function removeData($type){
        $data = self::where('type',$type)->first();
        if($data)
            $data->delete();

        return true;
    }
    public static function getActive(){
        return self::first();
    }
    public static function getNotActive(){
        return self::where('active',0)->first();
    }
}