<?php

namespace App\Models\Backend;
use Illuminate\Database\Eloquent\Model;

class Stockvalidation extends Model
{
    public $timestamps = false;

    protected $table = "stock_validation";

    const FILE_NAME = 'stock_lenses.csv';

    protected $guarded = [];
    protected $fillable = [
    	'material',
    	'colour',
    	'coating',
    	'sph',
    	'cyl',
    	'size',
    	'barcode',
        'price',
        'vendor',
        'cards'
    ];

    /**
    * Function to import Rx Lens from csv using cron job.
    */ 
    public static function import() {
        $filename = storage_path('app/public/imports/'.self::FILE_NAME);//public_path('imports/'.self::FILE_NAME);
        $row = 0;
        $handle = @fopen($filename, "r");
        $csvData = [];
        $first = true;
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                $data_values = [];
                $data = [
                    'material' =>  self::parseValue($row[1]),
                    'colour' =>  self::parseValue($row[2]),
                    'coating' =>  self::parseValue($row[3]),
                    'sph' =>  $row[4],
                    'cyl' =>  $row[5],
                    'barcode' =>  $row[7],
                    'vendor' =>  $row[8],
                    'price' =>  $row[9],
                    'cards' =>  $row[10],
                    'size' =>  $row[6],
                ];
                if($first){
                    $first = false;
                    self::truncate();
                }
                self::create($data);
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        fclose($handle);
        return true;
    }

    public static function parseValue($value)
    {
        // $value = strtolower($value);
        // $value = str_replace('.', '_point_', $value);
        // $value = str_replace(' ', '_', $value);
        // $value = str_replace('+', 'plus', $value);
        // $value = str_replace('-', 'minus', $value);
        // $value = str_replace("'", 'inverted', $value);
        
        return $value;
    }


    public function decodeValue($value)
    {
        $value = str_replace('_point_', '.', $value);
        $value = str_replace('_',' ', $value);
        $value = str_replace('plus','+', $value);
        $value = str_replace('minus','-', $value);
        $value = str_replace('inverted',"'", $value);
        
        return ucwords($value);
    }
}
