<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;
use App\Models\Auth\Traits\Relationship\UserProfileRelationship;
use App\Models\Backend\ReligionsList;

class UserProfile extends Model
{

    use UserProfileRelationship;

    public $timestamps = false;

    protected $table = "user_profile";

    protected $fillable = [
        'user_id',
        'business_name',
        'address1',
        'address2',
        'city',
        'state',
        'country',
        'zip_code',
        'phone',
        'fax',
        'date_of_birth',
        'religion',
        'ethnicity',
        'notes',
        'cust_ship_via_cod',
        'cust_commnt',
        'cust_language',
        'cust_phone_ext',
        'cust_on_hold',
        'cust_eom_table',
        'cust_group_cust_no',
        'cust_suppress_dollar',
        'cust_def_e_u',
        'cust_prlist_stock',
        'cust_prlist_default',
        'cust_type',
        'cust_freight_amt',
        'cust_contact_2',
        'cust_contact_3',
        'cust_group',
        'cust_vsp_office_code',
        'cust_cr_rating'
    ];

    public static function getReligionArrayLabel(){
        return ReligionsList::where('status',1)->get();
        // return [
        //     'Islamic'   =>  'Islamic',
        //     'Hindu'     =>  'Hindu',
        //     'International' =>  'International'
        // ];
    }

    public static function getEthnicityArrayLabel(){
        return [
            'White'   =>  'White',
            'Black'     =>  'Black',
            'Desi' =>  'Desi'
        ];
    }

    public function isFaxValid(){
        $explode = explode('-', $this->fax);
        if(count($explode) >= 2)
            return true;
        
        return false;
    }
}
