<?php

namespace App\Models\Backend;

use App\Models\Auth\User;
use App\Models\Backend\RxOrders;
use Illuminate\Database\Eloquent\Model;

class UserSettings extends Model
{
    public $timestamps = false;
    protected $table = "user_settings";

    protected $fillable = [
        'id',
        'user_id',
        'edge_polish',
        'bevel_type',
        'send_to',
        'order_placed',
        'order_shipped',
        'exceptions'
    ];

    protected $attributes = [
        'bevel_type' => 'lab_decided_best_level'
    ];

    /**
     * @return mixed
     */
    public function user()
    {
        return $this->hasOne(User::class,'id','user_id');
    }

    public static function getBevelTypeOptions(){
        $response = [];
        $data = RxOrders::getCombinationArray();
        if(isset($data['frame']['bevel_type']))
            $response = $data['frame']['bevel_type'];

        return $response;
    }

    public static function getPolishEdgesOptions(){
        $response = [
            '0'     =>  'Never',
            '1'     =>  'Always',
            '2'     =>  'As Instructed in Order'
        ];

        return $response;
    }

    public static function getSettings($attribute = null){
        $response = false;
        $model = self::where('user_id',auth()->user()->id)->first();
        if(!empty($model))
            $response = (!empty($attribute)) ? $model->$attribute : $model;

        return $response;
    }

    public static function getNotifications(){
        return [
            'order_placed'  =>  0,
            'exceptions'    =>  0,
            'order_shipped' =>  0
        ];
    }
}