<?php

namespace App\Models\Traits;

use Validator;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Http\Request;
use App\Custom\DropboxComponent;
use App\Models\Backend\Order;
use App\Models\Backend\AppSettings;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Models\Backend\OrderStatus;
/**
 * Trait Import.
 */
trait Import
{
    /**
     * @param $query
     * @param $uuid
     *
     * @return mixed
     */
    public function customers()
    {
        DropboxComponent::syncDrpboxFiles('/ls-hosting/labzilladata','customer.csv');
        $filename = public_path('imports/customer.csv');
        $handle = @fopen($filename, "r");
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                $parts = explode(" ", $row[7]);//CUST_CONTCT
                $code = (INT) $row[1];
                if(!empty($code) /*&& $code <= 999*/){
                    $contact2 = '';
                    if(!empty($row[51]) && str_contains('C:', $row[51])){
                        $contact2 = str_replace('C:', '', $row[51]);
                    }
                    $contact3 = '';
                    if(!empty($row[52]) && str_contains('C:', $row[52])){
                        $contact3 = str_replace('C:', '', $row[52]);
                    }
                    $request = new Request([
                        'first_name'            =>  array_shift($parts),
                        'last_name'             =>  array_pop($parts),
                        'email'                 =>  $row[101],//CUST_EMAIL
                        'ac_code'               =>  (INT) $row[1],//CUST_NO
                        'business_name'         =>  $row[0],//CUST_NAM
                        'created_at'            =>  date('Y-m-d H:i:s',strtotime($row[58])),//CUST_DATE_CREATED
                        'updated_at'            =>  date('Y-m-d H:i:s',strtotime($row[58])),//CUST_DATE_CREATED
                        'cust_ship_via_cod'     =>  $row[16],//CUST_SHIP_VIA_COD
                        'cust_commnt'           =>  $row[37],//CUST_COMMNT
                        'cust_phone_ext'        =>  $row[93],//CUST_PHONE_EXT
                        'cust_on_hold'          =>  $row[96],//CUST_ON_HOLD
                        'cust_eom_table'        =>  !empty($row[102]) ? $row[102] : 0,//CUST_EOM_TABLE
                        'cust_group_cust_no'    =>  !empty($row[106]) && is_numeric($row[106]) ? $row[106] : 0,//CUST_GROUP_CUST_NO 
                        // 'active'         =>  $row[107] == 'I' ? 0: 1,//CUST_ACTIVE_X
                        'cust_suppress_dollar'  =>  $row[113],//CUST_SUPPRESS_DOLLAR
                        'cust_def_e_u'          =>  $row[122],//CUST_DEF_E_U
                        'address1'              =>  $row[2],//CUST_ST_1
                        'address2'              =>  $row[3],//CUST_ST_2
                        'city'                  =>  $row[4],//CUST_CITY
                        'state'                 =>  $row[5],//CUST_STATE
                        'country'               =>  'Canada',
                        'zip_code'              =>  $row[6],//CUST_ZIP_COD
                        'phone'                 =>  str_replace('-', '', $row[8]),//CUST_PHONE_NO
                        'fax'                   =>  str_replace('-', '', $row[50]),//CUST_FAX_NO
                        'cust_type'             =>  $row[10],//CUST_TYP
                        'cust_freight_amt'      =>  $row[43],//CUST_FREIGHT_AMT
                        'notes'                 =>  $row[53],//CUST_NOTE_1
                        'password'              =>  \Illuminate\Support\Str::random(15),//base_convert(uniqid('pass', true), 10, 36),
                        'cust_prlist_default'   =>  $row[61],//CUST_PRLIST_DEFAULT
                        'cust_prlist_stock'     =>  $row[73],//CUST_PRLIST_STOCK
                        'cust_contact_2'     =>  $contact2,//CUST_CONTACT_2
                        'cust_contact_3'     =>  $contact3,//CUST_CONTACT_3
                        'cust_group'     =>  $row[59],//CUST_GROUP
                        'cust_vsp_office_code'     =>  $row[126],//CUST_VSP_OFFICE_CODE
                        'cust_cr_rating'     =>  $row[14],//CUST_CR_RATING
                    ]);
                    if (self::csValidation($request)->fails() == false) {
                        $userRepository = new UserRepository();
                        $userRepository->sync($request->all());
                    }
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
            fclose($handle);
        }
    }
    
    /**
     * Get the validation rules that apply to the request.
     * @param  $request
     *
     * @return boolean
     */
    public static function csValidation($request) {

        return Validator::make($request->toArray(), [
            'email'         => "required",
            'ac_code'       => "required",
            'first_name'    => "required"
        ]);
    }

    /**
     * @param $query
     * @param $uuid
     *
     * @return mixed
     */
    public function webOrderStatus(){
        $result = DropboxComponent::syncDrpboxFiles('/ls-hosting','LsWebStatus.csv');
        if($result){
            $filename = public_path('imports/LsWebStatus.csv');
            $handle = @fopen($filename, "r");

            if ($handle) {
                $fields = []; // Array to store column names
                $validationErrors = []; // Array to collect validation errors
                $requiredColumns = [
                    'Invoice_Number',
                    'Order_Number',
                    'Patient',
                    'Tray',
                    'Customer_Code',
                    'Order_Date',
                    'Order_Time',
                    'Status',
                    'Status_Date',
                    'Status_Time',
                    'Ship_Via',
                    'Tracking_Ref',
                    'ETA',
                    'lastUpdateDateTime',
                    'BrkgCategory',
                    'BrkgReason',
                    'OrderType',
                ];
                while (($row = fgetcsv($handle, 4096)) !== false) {
                    if (empty($fields)) {
                        $fields = $row; // Store the column headers
                        $missingColumns = array_diff($requiredColumns, $fields);
                        if (!empty($missingColumns)) {
                            $validationErrors[] = "Missing required columns: " . implode(', ', $missingColumns);
                            break; // Stop processing if required columns are missing
                        }
                        continue;
                    }
                    // Ensure the row has the same number of elements as the headers
                    if (count($fields) !== count($row)) {
                        $validationErrors[] = "Row does not match the header column count. Skipping row: " . implode(', ', $row);
                        continue;
                    }
                    // Map column names to values
                    $data = array_combine($fields, $row);

                    // Skip rows with invalid numeric fields
                    if (
                        !is_numeric($data['Invoice_Number'] ?? null) ||
                        !is_numeric($data['Tray'] ?? null) ||
                        !is_numeric($data['Customer_Code'] ?? null)
                    ) {
                        $validationErrors[] = "Row {$data['Invoice_Number']}: Numeric validation failed for fields (Invoice_Number, Tray, Customer_Code).";
                        continue;
                    }

                    // Validate date and time formats
                    $isValidDate = !empty($data['Order_Date']) && preg_match('/^\d{2}\/\d{2}\/\d{4}$/', $data['Order_Date']);
                    $isValidTime = !empty($data['Order_Time']) && preg_match('/^\d{2}:\d{2}:\d{2}$/', $data['Order_Time']);

                    if (!$isValidDate || !$isValidTime) {
                        $validationErrors[] = "Row {$data['Invoice_Number']}: Date or time format is invalid (Order_Date, Order_Time).";
                        continue;
                    }

                    // Process valid rows
                    if (!empty($data['Order_Number'])) {
                        OrderStatus::sync($data['Status']);
                        $orderNum = $data['Order_Number'];
                        $orderid = null;
                        $online = 0;

                        // Check if the order number starts with "W"
                        if (strpos($orderNum, "W") === 0) {
                            $orderid = str_replace("W", "", $orderNum);
                            $orderModal = Order::where(DB::raw('CAST(id AS CHAR)'), $orderid)
                                            ->where('online', 1)
                                            ->first();

                            if (!empty($orderModal)) {
                                $orderModal->updateOrderStatus($data);
                                $online = 1; // It's an online order
                            }
                        }

                        // If not an online order
                        if ($online === 0) {
                            $orderModal = Order::where('invoice_no', $data['Invoice_Number'])->first();

                            if (!empty($orderModal)) {
                                $orderModal->updateOrderStatus($data);
                            } else {
                                // Insert as a new order
                                $orderModal = new Order;
                                $type = $data['OrderType'] ?? null;

                                $newData = [
                                    'invoice_no'  => $data['Invoice_Number'],
                                    'patient'     => $data['Patient'] ?? null,
                                    'tray'        => $data['Tray'],
                                    'shipping_carrier' => isset($data['Ship_Via']) ? strtolower($data['Ship_Via']) : null,
                                    'tracking_no' => $data['Tracking_Ref'] ?? null,
                                    'eta'         => $data['ETA'] ?? null,
                                    'online'      => 0,
                                    'order_csv'   => $data['Order_Number'],
                                    'ac_code'     => $data['Customer_Code'],
                                    'status'      => $data['Status'] ?? null,
                                    'created_at'  => date('Y-m-d H:i:s'),
                                ];

                                // Handle custom created_at date
                                if ($isValidDate && $isValidTime) {
                                    $parts = explode('/', $data['Order_Date']);
                                    $newData['created_at'] = convert_date_time_utc(
                                        date('Y-m-d H:i:s', strtotime($parts[2] . "-" . $parts[0] . "-" . $parts[1] . ' ' . $data['Order_Time']))
                                    );
                                }

                                $orderModal = $orderModal->saveOffline($newData, $type);
                                if (!empty($orderModal)) {
                                    $orderModal->updateOrderStatus($data, 0);
                                }
                            }
                        }
                    }

                    if (!empty($data['lastUpdateDateTime'])) {
                        $settings = AppSettings::findByObj(AppSettings::LAST_UPDATE_ORDERS_TIME);
                        if (!empty($settings)) {
                            $settings->settings_value = convert_date_time_utc($data['lastUpdateDateTime']);
                            $settings->update();
                        }
                    }
                }

                if (!feof($handle)) {
                    echo "Error: unexpected fgets() fail";
                }
                fclose($handle);
                if (!empty($validationErrors)) {
                    Mail::raw(implode("\n", $validationErrors), function ($message) {
                        $message->to('usama485@gmail.com') // Replace with the recipient's email
                                ->subject('LsWebStatus.csv Validation Errors');
                    });
                }
            }
        }
    }
}
