<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Spatie\Dropbox\Client;
use League\Flysystem\Filesystem;
use Spatie\FlysystemDropbox\DropboxAdapter;

class DropboxServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->bind('dropbox', function() {
            $client = new Client(env('DROPBOX_ACCESS_TOKEN'));
            
            return new Filesystem(new DropboxAdapter($client));
        });
    }
}