<?php

namespace App\Services;
use Cron\CronExpression;
use Carbon\Carbon;
use App\Models\Backend\Cron;

class CronService
{
   public function getNextScheduledRun($expression)
    {
        $description = '';
        $cron = CronExpression::factory($expression);
        
        // Set timezone to Toronto for the next run date
        $nextRun = $cron->getNextRunDate(null, 0, false, 'America/Toronto');
        
        $parts = explode(' ', $expression);
        $minute = $parts[0];
        $hour = $parts[1];
        $day = $parts[2];
        $month = $parts[3];
        $weekday = $parts[4];
        
        // Minute part - fixed handling of 0
        if ($minute === '*') {
            $description .= 'Every minute';
        } elseif ($minute === '0') {
            $description .= 'At the start of the hour';
        } elseif (strpos($minute, '/') !== false) {
            list($interval, $value) = explode('/', $minute);
            $description .= "Every $value minutes";
        } else {
            $description .= "At minute $minute";
        }

        // Hour part
        if ($hour === '*') {
            $description .= ' of every hour';
        } elseif (strpos($hour, '-') !== false) {
            list($start, $end) = explode('-', $hour);
            // Convert 24-hour to 12-hour format for description
            $start12 = date('g A', strtotime("$start:00"));
            $end12 = date('g A', strtotime("$end:00"));
            $description .= ", between $start12 and $end12";
        } elseif (strpos($hour, '/') !== false) {
            list($interval, $value) = explode('/', $hour);
            $description .= ", every $value hours";
        } else {
            // Convert 24-hour to 12-hour format for description
            $hour12 = date('g A', strtotime("$hour:00"));
            $description .= ", at $hour12";
        }

        // Day part
        if ($day === '*') {
            $description .= ', every day';
        } elseif (strpos($day, '/') !== false) {
            list($interval, $value) = explode('/', $day);
            $description .= ", every $value days";
        } else {
            $description .= ", on day $day of the month";
        }

        // Month part
        if ($month === '*') {
            $description .= ', every month';
        } else {
            $description .= ", in month $month";
        }

        // Weekday part
        if ($weekday === '*') {
            $description .= '';
        } elseif (strpos($weekday, '-') !== false) {
            list($start, $end) = explode('-', $weekday);
            $description .= ", on weekdays from $start to $end";
        } elseif (strpos($weekday, ',') !== false) {
            $days = explode(',', $weekday);
            $description .= ", on weekdays " . implode(', ', $days);
        } else {
            $description .= ", on weekday $weekday";
        }

        // Format the date in 12-hour format with AM/PM
        $formattedDate = $nextRun->format('d-m-Y h:i:s A');
        return response()->json([
            'short_description' => $description, 
            'nextRun' => $formattedDate,
            'timezone' => 'America/Toronto'
        ]);
    }

    public static function log($cronName, $status, $errorLog = null)
    {
        $currentTimeToronto = Carbon::now('America/Toronto')->format('d-m-Y h:i:s A');
        Cron::updateOrCreate(
            ['name' => $cronName],
            [
                'name'              => $cronName,
                'status'            => $status,
                'last_scheduled'    => $currentTimeToronto,
                'logs'              => $errorLog,
            ]
        );
    }
}