(function() {
    function init() {
        const plusBtns      =   document.querySelectorAll('.plus-btn');
        const minusBtn      =   document.querySelectorAll('.minus-btn');
        const variantLists  =   document.querySelectorAll('.variant-list');
        const container     =   document.querySelector('.consumable-summary-container');

        // code to disable order submit button
        const submitButton = document.querySelector('.btn-submit');
        if (submitButton) {
            submitButton.disabled = true;
            submitButton.classList.add('disabled');
        }

        // Loop through each plusBtn and add event listeners
        plusBtns.forEach(btn => {
            btn.addEventListener('mouseenter', () => {
                btn.style.backgroundColor   = '#3598dc';
                btn.style.borderColor       = '#3598dc';
            });
            btn.addEventListener('mouseleave', () => {
                btn.style.backgroundColor   = '';
                btn.style.borderColor       = '';
            });
            btn.addEventListener('click', function() {
                const qtyInput      = btn.previousElementSibling;
                let currentValue    = parseFloat(qtyInput.value) || 0;
                if (currentValue < parseFloat(qtyInput.max)) {
                    qtyInput.value = currentValue + 1;
                }
                const currentVariantList = btn.closest('.variant-list');
                updateCart(currentVariantList, qtyInput.value);
                checkCartForItems();
            });
        });

        // Loop through each minusBtn and add event listeners
        minusBtn.forEach(btn => {
            btn.addEventListener('mouseenter', () => {
                btn.style.backgroundColor = '#e7505a';
                btn.style.borderColor = '#e7505a';
            })
            btn.addEventListener('mouseleave', () => {
                btn.style.backgroundColor = '';
                btn.style.borderColor = '';
            })
            btn.addEventListener('click', () => {
                const qtyInput = btn.nextElementSibling;
                let currentValue = parseFloat(qtyInput.value) || 0;
                if (currentValue > parseFloat(qtyInput.min)) {
                    qtyInput.value =  currentValue - 1;
                }
                if (qtyInput.value == 0) {
                    qtyInput.value = '';
                    const currentVariantList = btn.closest('.variant-list');
                    removeItemFromCart(currentVariantList);
                } else {
                    const currentVariantList = btn.closest('.variant-list');
                    updateCart(currentVariantList, qtyInput.value);
                }
                checkCartForItems();
            });
        });

        // Function to remove item from cart
        function removeItemFromCart(currentVariantList)
        {
            const variantProdctId   = currentVariantList.getAttribute('data-variant-id');
            const container         = document.querySelector('.consumable-summary-container');
            const existingItem      = container.querySelector(`.cart-container-${variantProdctId}`);
            if (existingItem) existingItem.remove();
            let total = 0;
            container.querySelectorAll('.i-price').forEach(priceElem => {
                total += parseFloat(priceElem.innerHTML.replace('$', '').trim());
            });
            const formattedTotal = total.toFixed(2);
            document.querySelector('#t_price-field').innerHTML = `${formattedTotal}`;
            if (container.children.length === 1) {
                document.querySelector('.empty-cart-label').style.display = 'block';
                document.querySelector('.inherit-price-container').style.display = 'none';  
                document.querySelector('.inherit-price-container-1').style.display = 'none';  
            }
        }

        // Get data-variant and card-title dynamically
        function updateCart(currentVariantList, selectQty) {
            const variantProdctTitle = currentVariantList.getAttribute('data-variant');
            const variantProdctId = currentVariantList.getAttribute('data-variant-id');
            const parentProductTitle = currentVariantList.closest('.col-md-8').querySelector('.card-title').innerHTML;
            const baseProductPrice = parseFloat(currentVariantList.getAttribute('data-variant-price')) || 0;
            let container = document.querySelector('.consumable-summary-container');
            let existingItem = container.querySelector(`.cart-container-${variantProdctId}`);

            if (existingItem) {
                const priceElement = existingItem.querySelector('.i-price');
                if (priceElement) {
                    priceElement.innerHTML = baseProductPrice > 0 ? `${(selectQty * baseProductPrice).toFixed(2)}` : '';
                }
                let updateQty = existingItem.querySelector('.qty');
                updateQty.innerHTML = `${selectQty}x`;
            } else if (selectQty > 0) {
                let htmlContent = renderHtml(variantProdctId, parentProductTitle, variantProdctTitle, baseProductPrice, selectQty);
                container.insertAdjacentHTML('beforeend', htmlContent);
                document.querySelector('.empty-cart-label').style.display = "none";
            }

            updateTotalPriceDisplay();
        }

        // function to handle total price display logic
        function updateTotalPriceDisplay() {
            let total = 0;
            let allItemsHavePrice = true;
            const container = document.querySelector('.consumable-summary-container');
            
            container.querySelectorAll('.cart-container').forEach(item => {
                const priceElement = item.querySelector('.i-price');
                if (priceElement) {
                    const priceText = priceElement.textContent.trim();
                    if (priceText) {
                        total += parseFloat(priceText.replace('$', ''));
                    } else {
                        allItemsHavePrice = false;
                    }
                }
            });
            
            const formattedTotal = total.toFixed(2);
            const totalPriceField = document.querySelector('#t_price-field');
            if (totalPriceField) {
                totalPriceField.innerHTML = `${formattedTotal}`;
            }
            
            // Show price containers only if ALL items have prices
            const shouldShowPrice = allItemsHavePrice && container.querySelectorAll('.cart-container').length > 0;
            document.querySelectorAll('.inherit-price-container, .inherit-price-container-1').forEach(el => {
                el.style.display = shouldShowPrice ? 'block' : 'none';
            });
        }


        // Add event delegation for the trash icon to reset the input box value
        const consumableContainer = document.querySelector('.consumable-summary-container');
        if (consumableContainer) {
            consumableContainer.addEventListener('click', function(event)
            {
                if (event.target.closest('.remove-item')) {
                    const removeBtn = event.target.closest('.remove-item');
                    const variantId = removeBtn.getAttribute('data-id');
                    // Reset the input field value
                    const inputField = document.querySelector(`.variant-list[data-variant-id="${variantId}"] .qty-input`);
                    if (inputField) inputField.value = '';
                    // Remove the item from the cart
                    const currentVariantList = document.querySelector(`.variant-list[data-variant-id="${variantId}"]`);
                    removeItemFromCart(currentVariantList);
                    checkCartForItems();
                }
            });
        }


        // Cart reset button to clear the cart data
        const btnReset = document.querySelector('.btn-reset');
        if (btnReset) {
            btnReset.addEventListener('click', () => {
                    variantLists.forEach(variantList =>  {
                        const inputField = variantList.querySelector('.qty-input');
                        if (inputField) inputField.value = '';
                        removeItemFromCart(variantList);
                        checkCartForItems();
                })
            });
        }

        // Function to render the cart HTML
        function renderHtml(variantProdctId, parentProductTitle, variantProdctTitle, baseProductPrice, selectQty) {
            const priceContent = baseProductPrice > 0 ?
                `$<span class="i-price">${(baseProductPrice * selectQty).toFixed(2)}</span>` :
                '<span class="i-price"></span>';

            return `
                <div class="row position-relative cart-container cart-container-${variantProdctId}">
                    <div class="col-1 p-0">&nbsp;</div>
                    <div class="col-11 p-0 row" style="">
                        <span class="col-sm-1 p-0 bold qty">${selectQty}x</span>
                        <span class="col-sm-8"> ${parentProductTitle} - ${variantProdctTitle}</span>
                        <a href="javascript:void(0);" class="col-sm-1 remove-item" data-id="${variantProdctId}">
                            <i class="fa fa-trash-o delete-btn" style="float: right;padding-top: 3px;"></i>
                        </a>
                        <span class="col-sm-2 item-price bold">
                            <div>${priceContent}</div>
                        </span>
                    </div>
                </div>
            `;
        }

        // code to replace secondary images with primanty one start

        let previousVariantLabel = null;
        variantLists.forEach(variantList => {
            variantList.addEventListener('mouseenter', () => {
                // Change text color
                const span = variantList.querySelector('.variant-label');
                if (span) {
                    span.classList.add('text-primary');
                    span.classList.remove('font-larger');
                    span.classList.add('font-large');
                    // Remove the 'text-primary' class from the previous variant if there was one
                    if (previousVariantLabel && previousVariantLabel !== span) {
                        previousVariantLabel.classList.remove('text-primary');
                        previousVariantLabel.classList.remove('font-large');
                        previousVariantLabel.classList.add('font-larger');
                    }
                    previousVariantLabel = span;
                }
                const variantImage = variantList.querySelector('.variant-list-item.section-1').getAttribute('data-variant-image');
                const imageToReplace = variantList.closest('.row').querySelector('.image-container .imageToReplace');
                if (imageToReplace && variantImage) {
                    imageToReplace.src = variantImage;
                }

                // Change price on hover
                const variantPrice = variantList.getAttribute('data-variant-price');
                const cardPriceElement = variantList.closest('.col-md-8').querySelector('.card-price');
                cardPriceElement.textContent = parseFloat(variantPrice).toFixed(2);
                if (cardPriceElement && variantPrice) {
                    if (variantPrice == 0) {
                        cardPriceElement.textContent = "Contact";
                        // Hide the dollar sign if price is 0
                        const itemSymbol = variantList.closest('.col-md-8').querySelector('.item-symbol');
                        if (itemSymbol) itemSymbol.style.display = 'none';
                    } else {
                        cardPriceElement.textContent = parseFloat(variantPrice).toFixed(2);
                        // Show dollar sign if it was hidden
                        const itemSymbol = variantList.closest('.col-md-8').querySelector('.item-symbol');
                        if (itemSymbol) itemSymbol.style.display = '';
                    }
                }



            });
        });

        // code to replace secondary images with primanty one end

        // function to save consumable order start


        function submitCousmableOrder() {
            const submitButton = document.querySelector('.submit-consumable-order');
            const originalText = submitButton.textContent;
            showLoader();
            submitButton.textContent = 'Submitting';
            submitButton.disabled = true; // Optional: Disable button during processing

            let payload = [];
            let confirm_order = true;
            let ordertotalAmount = document.querySelector('#t_price-field');
            let cartContainer = document.querySelectorAll('.cart-container');

            cartContainer.forEach(cartContainerElement => {
                const classList = cartContainerElement.classList;
                const cardId = Array.from(classList).find(className => className.startsWith('cart-container-'));
                const itemId = cardId ? cardId.split('-')[2] : null;
                let basePrice = cartContainerElement.querySelector('.i-price');
                let qtySpan = cartContainerElement.querySelector('.qty');
                let qtyText = qtySpan ? qtySpan.textContent : '';
                let itemQty = parseInt(qtyText, 10);
                payload.push({
                    basePrice: basePrice.textContent,
                    itemQty: itemQty,
                    itemId: itemId,
                });
            });

            fetch('/store-consumables-order', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    orderData: payload,
                    confirm_order: confirm_order,
                    ordertotalAmount: ordertotalAmount.textContent,
                })
            })
            .then(response => response.json())
            .then(data => {
                hideLoader();
                submitButton.textContent = originalText;
                submitButton.disabled = false; // Re-enable button
                window.location.href = '/orders/confirm/' + data.order_id;
            })
            .catch(error => {
                hideLoader();
                submitButton.textContent = originalText;
                submitButton.disabled = false; // Re-enable button
                window.location.href = '/orders/';
            });
        }

        // Expose the function globally
        window.submitCousmableOrder = submitCousmableOrder;

        // Function to show loader
        function showLoader() {
            $('.chatpageloader').show();
        }

        // Function to hide loader
        function hideLoader() {
            $('.chatpageloader').hide();
        }
        // function to save consumable order end

        function checkCartForItems() {
            const cartContainers = document.querySelectorAll('.cart-container');
            const submitButton = document.querySelector('.btn-submit');
            const container = document.querySelector('.consumable-summary-container');
            
            if (cartContainers.length > 0) {
                if (submitButton) {
                    submitButton.classList.remove('disabled');
                    submitButton.disabled = false;
                }
                document.querySelector('.empty-cart-label').style.display = "none";
                updateTotalPriceDisplay();
            } else {
                if (submitButton) {
                    submitButton.classList.add('disabled');
                    submitButton.disabled = true;
                }
                document.querySelector('.empty-cart-label').style.display = 'block';
                document.querySelectorAll('.inherit-price-container, .inherit-price-container-1').forEach(el => {
                    el.style.display = 'none';
                });
            }
        }

        if (container) {
            container.addEventListener('mouseover', (event) => {
                const row = event.target.closest('.remove-item')?.closest('.cart-container')?.querySelector('.col-11');
                if (row) row.style.backgroundColor = '#FFF4F3';
            });

            container.addEventListener('mouseout', (event) => {
                const row = event.target.closest('.remove-item')?.closest('.cart-container')?.querySelector('.col-11');
                if (row) row.style.backgroundColor = '';
            });
        }

        const modal = document.getElementById('imageModal');
        const modalImg = document.getElementById('modalImage');
        const closeBtn = document.querySelector('.close-btn');
        const leftArrow = document.querySelector('.left-arrow');
        const rightArrow = document.querySelector('.right-arrow');
        const modalContent = document.querySelector('.modal-content');
        let currentImageIndex = 0;
        let images = [];
        let variantLabels = [];
        let variantTexts = [];

        // Function to open the modal and display the clicked image
        function openModal(imageSrc, subImages, labels, texts) {
            if (!modal) return;
            // Set modal content
            modal.style.display = 'flex';
            images = subImages;
            variantLabels = labels;
            variantTexts = texts;
           // If no images, close modal
            if (images.length === 0) {
                modal.style.display = 'none';
                return;
            }
            // For 1 or 2 images, always show first image
            if (images.length <= 2) {
                currentImageIndex = 0;
            }
            // For more than 2 images, show the selected image
            else {
                currentImageIndex = images.findIndex(img => img === imageSrc);
                // If selected image not found, default to first image
                if (currentImageIndex === -1) currentImageIndex = 0;
            }
            if (modalImg) modalImg.src = images[currentImageIndex];
            updateVariantInfo();
            updateArrowVisibility();
            setTimeout(updateArrowPositions, 50);
        }

        // Function to close the modal
        function closeModal() {
            if (modal) modal.style.display = 'none';
        }

        // Function to navigate to the previous image
        function showPreviousImage() {
            if (images.length <= 1) return; // Don't proceed if only one image
            if (currentImageIndex > 0) {
                currentImageIndex--;
                if (modalImg) modalImg.src = images[currentImageIndex];
                updateVariantInfo();
                updateArrowVisibility();
            }
        }
        // Function to navigate to the next image
        function showNextImage() {
            if (images.length <= 1) return; // Don't proceed if only one image
            if (currentImageIndex < images.length - 1) {
                currentImageIndex++;
                if (modalImg) modalImg.src = images[currentImageIndex];
                updateVariantInfo();
                updateArrowVisibility();
            }
        }

        // Function to update the variant label and text
        function updateVariantInfo() {
            const variantLabelElement = document.getElementById('data-variant-label');
            const variantTextElement = document.getElementById('data-variant');
            const variantInfoDiv = document.querySelector('.variant-info');

            if (variantLabels[currentImageIndex] && variantTexts[currentImageIndex]) {
                if (variantLabelElement) variantLabelElement.textContent = variantLabels[currentImageIndex];
                if (variantTextElement) variantTextElement.textContent = variantTexts[currentImageIndex];
                if (variantInfoDiv) variantInfoDiv.style.display = 'flex';
            } else {
                if (variantInfoDiv) variantInfoDiv.style.display = 'none';
            }
        }

        // Function to update arrow positions based on image size
        function updateArrowPositions() {
            if (!modalImg || modalImg.clientWidth === 0) return;
            if (!modalContent) return;

            const imageWidth = modalImg.clientWidth;
            const modalContentWidth = modalContent.clientWidth;

            const imageLeftEdge = (modalContentWidth - imageWidth) / 2;
            const imageRightEdge = imageLeftEdge + imageWidth;

            if (leftArrow) leftArrow.style.left = `${imageLeftEdge - 50}px`;
            if (rightArrow) rightArrow.style.right = `${modalContentWidth - imageRightEdge - 50}px`;
        }

        // Function to update arrow visibility and opacity
        function updateArrowVisibility() {
            // Hide both arrows if there's only one image
            if (images.length <= 1) {
                if (leftArrow) leftArrow.style.display = 'none';
                if (rightArrow) rightArrow.style.display = 'none';
                return;
            }
            // Left arrow - hide if at first image, show otherwise
            if (currentImageIndex === 0) {
                if (leftArrow) leftArrow.style.display = 'none';
            } else {
                if (leftArrow) {
                    leftArrow.style.display = 'block';
                    leftArrow.style.opacity = '1';
                    leftArrow.style.cursor = 'pointer';
                }
            }
            // Right arrow - hide if at last image, show otherwise
            if (currentImageIndex === images.length - 1) {
                if (rightArrow) rightArrow.style.display = 'none';
            } else {
                if (rightArrow) {
                    rightArrow.style.display = 'block';
                    rightArrow.style.opacity = '1';
                    rightArrow.style.cursor = 'pointer';
                }
            }
        }

        // Ensure arrow positions are updated after the image loads
        if (modalImg) {
            modalImg.onload = function () {
                updateArrowPositions();
                updateArrowVisibility();
            };
        }

        // Event listeners for image clicks
        document.querySelectorAll('.imageToReplace').forEach((img) => {
            img.addEventListener('click', function() {
                if (this.src.includes('water-mark.png')) return;

                const card = this.closest('.card');
                const subImages = [];
                const labels = [];
                const texts = [];

                // Collect all variant data
                const variantLists = card.querySelectorAll('.variant-list');
                variantLists.forEach(list => {
                    // const items = list.querySelectorAll('[data-variant-image], [data-variant-image-sub]');
                    const items = list.querySelectorAll('[data-variant-image], [data-variant-image-sub]');
                    items.forEach(item => {
                        const label = list.getAttribute('data-variant-label');
                        const text = list.getAttribute('data-variant');
                        if (item.dataset.variantImage) {
                            subImages.push(item.dataset.variantImage);
                            labels.push(label);
                            texts.push(text);
                        }
                        if (item.dataset.variantImageSub) {
                            subImages.push(item.dataset.variantImageSub);
                            labels.push(label);
                            texts.push(text);
                        }
                    });
                });
                openModal(this.src, subImages, labels, texts);
            });
        });
        // Event listeners for modal controls
        if (closeBtn) closeBtn.addEventListener('click', closeModal);
        if (leftArrow) leftArrow.addEventListener('click', showPreviousImage);
        if (rightArrow) rightArrow.addEventListener('click', showNextImage);

        // Close modal when clicking outside the image
        window.addEventListener('click', function (event) {
            if (modal && event.target === modal) {
                closeModal();
            }
        });

        // Update arrow positions on window resize
        window.addEventListener('scroll', updateArrowPositions);
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();  // DOM is already ready—run now
    }
})();