(function() {
    function init() {
        //  Color Status Tab grid code start
        document.addEventListener('click', (event) => {
            if (event.target.matches('#loadOrdertatus')) {
                document.getElementsByClassName('cron-alert')[0].style.display = 'none';
                loadOrderStatusGrid();
            }
        });

        document.addEventListener('click', (event) => {
            if (event.target.matches('#loadCronGrid')) {
                document.getElementsByClassName('cron-alert')[0].style.display = 'none';
                loadCronGrid();
            }
        });

        function attachDragAndDropListeners() {
            let draggedRow = null;
            // Drag start event (delegated to #tableBody)
            $('#tableBody').on('dragstart', 'tr', function (e) {
                draggedRow = $(this); // Store the dragged row
                $(this).css('opacity', '0.4'); // Visual feedback
            });

            // Drag over event (delegated to #tableBody)
            $('#tableBody').on('dragover', 'tr', function (e) {
                e.preventDefault(); // Allow drop
                const targetRow = $(this); // Get the target row

                // Ensure we're not comparing the dragged row with itself
                if (targetRow[0] !== draggedRow[0]) {
                    const rect = targetRow[0].getBoundingClientRect(); // Get target row's position
                    const next = (e.originalEvent.clientY - rect.top) / (rect.bottom - rect.top) > 0.5; // Check mouse position

                    // Insert the dragged row before or after the target row
                    if (next) {
                        targetRow.after(draggedRow);
                    } else {
                        targetRow.before(draggedRow);
                    }
                }
            });

            // Drag end event (delegated to #tableBody)
            $('#tableBody').on('dragend', 'tr', function (e) {
                $(this).css('opacity', '1');
                updateSortingOrder();
            });
        }

        // Function to update sorting order in the database
        function updateSortingOrder() {
            const order = [];
            const rows = document.querySelectorAll('#tableBody tr');
            rows.forEach((row, index) => {
                const rowId = row.getAttribute('data-id'); // Get the row ID
                if (!rowId) return;  // Skip rows without a data-id attribute
                order.push({ id: rowId, sort_order: index + 1 }); // Add row ID and new sort order
            });

            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            fetch('/update-sorting-order', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify({ order: order })
            })
            .then(response => response.json())
            .then(data => {
                // Update the sorting column in the DOM
                rows.forEach((row, index) => {
                    const sortingCell = row.children[4]; // Assuming the sorting column is the 5th column (0-based index)
                    sortingCell.textContent = index + 1; // Update the sorting column value
                });
            })
            .catch(error => {
                console.error('Error updating sorting order:', error);
            });
        }

        // Function to load order status grid
        function loadOrderStatusGrid() {
            let indexURL = document.getElementById('orderStatusData').getAttribute('data-order-index');
            $.ajax({
                url: indexURL,
                method: "GET",
                success: function(response) {
                    let orderstatus = response.orderstatus;
                    let stylesHtml = `
                                    <div class="table-responsive order-status-table">
                                        <table class="table table-bordered table-striped table-hover data-table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Title</th>
                                                <th>Color</th>
                                                <th>Sorting</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tableBody">`;

                    orderstatus.forEach(function(order) {
                        stylesHtml += `
                            <tr data-id="${order.id}" id="order-${order.id}" draggable="true">
                                <td>${order.id}</td>
                                <td>${order.name}</td>
                                <td>${order.title}</td>
                                <td id="${order.id}" class="main-color-picker">
                                    <span class="pick-color"><input type="color" value="${order.color}" style="background-color:${order.color}" class="color-picker" onchange="updateColor(this, '${order.id}', 'update')"></span>
                                    <span class="color-code" onclick="updateColor(this, '${order.id}', 'edit')">${order.color}</span>
                                </td>
                                <td>${order.sorting}</td>
                                <td class="${order.active == '1' ? 'text-success' : 'text-danger'}">  ${order.active == '1' ? 'Active' : 'InActive'} </td>
                            </tr>
                        `;
                    });

                    stylesHtml += `
                    </tbody>
                    </table>
                    </div>
                    `;

                    $('#orderStatusData').html(stylesHtml);
                    // Re-attach drag-and-drop listeners after content is loaded
                    attachDragAndDropListeners();
                },
                error: function() {
                    $('#orderStatusData').html('<p>Sorry, there was an error loading the data.</p>');
                }
            });
        }

        // Function to update the color in the database
        function updateColor(colorInput, orderId, type)
        {
            const selectedColor = colorInput.value;
            const td = document.getElementById(orderId);
            if (td && type == 'update') {
                td.innerHTML = '';
                // Create the color code span
                let colorCode = document.createElement('span');
                colorCode.classList.add('color-code');
                colorCode.textContent = selectedColor;
                colorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);

                // Create the pick-color span element
                let pickColor = document.createElement('span');
                pickColor.classList.add('pick-color');

                // Create the color input element
                let colorInputElement = document.createElement('input');
                colorInputElement.type = 'color';
                colorInputElement.value = selectedColor;
                colorInputElement.style.backgroundColor = selectedColor;
                colorInputElement.classList.add('color-picker');
                colorInputElement.setAttribute('onchange', `updateColor(this, '${orderId}', 'update')`);

                // Append the color input to the pick-color span
                pickColor.appendChild(colorInputElement);

                // Append both spans to the parent td element
                td.appendChild(pickColor);
                td.appendChild(colorCode);
            }

            const colorCode = td.querySelector('.color-code');
            if (colorCode && type == 'edit') {
                // Replace the color code span with an input field
                const colorInputElement = document.createElement('input');
                colorInputElement.type = 'text';
                colorInputElement.value = colorCode.textContent;
                colorInputElement.classList.add('input-color-picker');
                colorInputElement.setAttribute('onchange', `updateColor(this, '${orderId}', 'update')`);
                // Replace the color code span with the new input
                td.replaceChild(colorInputElement, colorCode);
                colorInputElement.focus(); // Focus on the new input field

                // Add event listener to detect clicks outside the input field
                document.addEventListener('click', function onClickOutside(event) {
                    // Check if the click is outside the td and not on the .color-code element
                    if (!td.contains(event.target) && !event.target.closest('.color-code')) {
                        // Check if the colorInputElement is still a child of the td
                        if (td.contains(colorInputElement)) {
                            // If the click is outside the td and not on .color-code, revert the input back to a span
                            const updatedColorCode = document.createElement('span');
                            updatedColorCode.classList.add('color-code');
                            updatedColorCode.textContent = colorInputElement.value;
                            updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                            // Replace the input with the new span
                            td.replaceChild(updatedColorCode, colorInputElement);
                        }
                        // Remove the event listener
                        document.removeEventListener('click', onClickOutside);
                    }
                });
            }
            if (colorInput.value !== undefined && colorInput.value !== null && colorInput.value !== '') {
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '/update-color', true);
                xhr.setRequestHeader('Content-Type', 'application/json');
                var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);

                xhr.onload = function () {
                    if (xhr.status === 200) {
                        colorInput.style.backgroundColor = colorInput.value;
                        if (type == 'edit') {
                            const updatedColorCode = document.createElement('span');
                            updatedColorCode.classList.add('color-code');
                            updatedColorCode.textContent = colorInput.value;
                            updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                            td.replaceChild(updatedColorCode, colorInput);
                            // Reload the entire page after success
                            document.getElementById('loadOrdertatus').click();
                        }
                    }
                };
                xhr.send(JSON.stringify({
                    orderId: orderId,
                    newColor: selectedColor
                }));
            } else {
                // If no change, revert to the original color code span
                const colorCode = td.querySelector('.color-code');
                if (colorCode) {
                    const originalColor = colorCode.textContent; // Get the original color value
                    const updatedColorCode = document.createElement('span');
                    updatedColorCode.classList.add('color-code');
                    updatedColorCode.textContent = originalColor;
                    updatedColorCode.setAttribute('onclick', `updateColor(this, '${orderId}', 'edit')`);
                    // Replace the input with the original span (color code)
                    td.replaceChild(updatedColorCode, colorInput);
                }
            }
        }
        //  Color Status Tab grid code end

        function modifyDescription(td) {
            // Check if already in edit mode (input field exists)
            if (td.querySelector('input')) {
                return; // Exit if already editing
            }
            
            var originalContent = td.textContent.trim(); // Use textContent to avoid HTML issues
            td.innerHTML = `<input type="text" value="${originalContent}" 
                                  onblur="saveDescription(this, ${td.id})" 
                                  class="editable-input" maxlength="255" />`;
            td.querySelector('input').focus();
        }

        function saveDescription(input, id) {
            var updatedDescription = input.value;
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '/save-description', true);
            xhr.setRequestHeader('Content-Type', 'application/json');
            var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    input.parentElement.innerHTML = updatedDescription;
                }
            };
            xhr.send(JSON.stringify({
                id: id,
                description: updatedDescription
            }));
        }

        function loadCronGrid() {
            const headerClass = document.querySelector('.navbar');
            const pageContent = document.querySelector('.page-content');
            if (pageContent) {
                pageContent.style.maxWidth = 'inherit';
                pageContent.style.width = '100%';
                pageContent.style.maxWidth = '100%';
                if (headerClass) {
                    headerClass.style.maxWidth = '100%';
                    headerClass.style.width = '100%';
                }
                const profileBtn = document.querySelector('.profile-btn');
                if (profileBtn) {
                    profileBtn.style.float = 'right';
                }
                const pageLogo = document.querySelector('.page-logo');
                if (pageLogo) {
                    pageLogo.style.float = 'left';
                }
            }
            let indexURL = document.getElementById('cronData').getAttribute('data-cron-index');
            $.ajax({
                url: indexURL,
                method: "GET",
                success: function(response) {
                    let crons = response.crons;
                    let stylesHtml = `
                                    <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm table-hover w-auto data-table">
                                        <thead>
                                            <tr>
                                                <th>Command</th>
                                                <th>Description</th>
                                                <th>Name</th>
                                                <th>Short Description</th>
                                                <th>Last Ran</th>
                                                <th>Next Scheduled</th>
                                                <th>Status</th>
                                                <th>Minute</th>
                                                <th>Hour</th>
                                                <th>Day</th>
                                                <th>Month</th>
                                                <th>Weekday</th>
                                            </tr>
                                        </thead>
                                        <tbody>`;
                                        crons.forEach(function(cron) {
                                            stylesHtml += `
                                                <tr>
                                                    <td title="${cron.command}">${cron.command && cron.command.length > 100 ? cron.command.substring(0, 100) + '...' : cron.command}</td>
                                                    <td class="text-wrap" style="width: 50rem;" 
                                                        onclick="modifyDescription(this)" 
                                                        ondblclick="return false;" 
                                                        id="${cron.id}"
                                                        data-original-content="${cron.description && cron.description.length > 100 ? cron.description.substring(0, 100) + '...' : cron.description}">
                                                        ${cron.description && cron.description.length > 100 ? cron.description.substring(0, 100) + '...' : cron.description}
                                                    </td>
                                                    <td>${cron.name ? cron.name : '-'}</td>
                                                    <td>${cron.short_description}</td>
                                                    <td>${cron.last_scheduled ? cron.last_scheduled : '-'}</td>
                                                    <td>${cron.next_scheduled}</td>
                                                    <td class="${cron.status == '1' ? 'text-success' : cron.status == '2' ? 'text-warning' : 'text-danger'}">
                                                        ${cron.status == '1' ? 'Success' : cron.status == '2' ? 'Disabled' : 'Error'}
                                                    </td>
                                                    <td>${cron.minute}</td>
                                                    <td>${cron.hour}</td>
                                                    <td>${cron.day}</td>
                                                    <td>${cron.month}</td>
                                                    <td>${cron.weekday}</td>
                                                    <td>
                                                        <a href="#" class="btn btn-info btn-sm" onclick="getLogs(${cron.id})">Logs</a>
                                                    </td>
                                                </tr>
                                            `;
                                        });
                                stylesHtml += `
                                </tbody>
                            </table>
                        </div>
                            `;
                    $('#cronData').html(stylesHtml);
                },
                error: function() {
                    $('#cronData').html('<p>Sorry, there was an error loading the data.</p>');
                }
            });
        }

        function getLogs(id) {

            let xhr = new XMLHttpRequest();
            xhr.open('GET', '/get-logs?id=' + id, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    let response = JSON.parse(xhr.responseText);
                    let logs = response.message.logs;
                    if (!logs) logs = 'No logs available for this job.';
                    document.getElementById('logsContent').innerText = logs;
                    $('#logsModal').modal('show');
                } else {
                    console.error('Request failed with status: ' + xhr.status);
                }
              };
            xhr.onerror = function() {
                console.error('Request failed');
            };
            xhr.send();
        }

        // Make functions global
        window.loadOrderStatusGrid = loadOrderStatusGrid;
        window.loadCronGrid = loadCronGrid;
        window.updateColor = updateColor;
        window.modifyDescription = modifyDescription;
        window.saveDescription = saveDescription;
        window.getLogs = getLogs;
        window.attachDragAndDropListeners = attachDragAndDropListeners;
        window.updateSortingOrder = updateSortingOrder;

        // Cron Tab grid code end
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();  // DOM is already ready—run now
    }
})();