var table = '';
var $loading = $('.loader');
var deleteBtnTimer;
var documentHeight = 0;
var isSelectedOrderOpened = false;
$.fn.hasAttr = function(name) {
   return this.attr(name) !== undefined;
};
// windowResize();

$(function() {


    var blockUIFlag = true;
    $(".select2_custom").select2({
        placeholder: "Select...",
        // allowClear: true,
        width: '130px'
    });
    $(".select2_apply").select2({
        width: '350px'
    });
    $(".select2_tags").select2({
        width: '350px',
        tags: true
    });
    $(".select2_fixed").select2({
        width: '350px'
    });
    $('.datepicker').datepicker();
    if (typeof $.fn.DataTable  != 'undefined') {
        table = $('.table-data_table').DataTable({
            "paging": false,
            'info':false,
            "searching": false,
            "aaSorting": [],
            "columnDefs": [
               { orderable: false, targets: -1 }
            ]
        });
    }

    $.each( $('.always-open'), function( key, value ) {
        if(!$(this).closest('.nav-item').hasClass('active'))
            $(this).toggle();
    });

    $(document).ajaxComplete(function(r, s) {
        if ($.active > 1) {
            return; // Exit if there are still pending AJAX requests
        }
        $('.preloader').fadeOut();
        // App.unblockUI();
        if(window.isLoaderStop)
            $loading.hide();

        $('.table-loader').addClass('chide');
        if (typeof $.fn.DataTable  != 'undefined' && ! $.fn.DataTable.isDataTable( '.table-data_table' ) ) {
            table = $('.table-data_table').DataTable({
                "paging": false,
                'info':false
            });
        }
        $('.orders_shipped').popover({
            html: true,
            placement: 'top',
            trigger: 'hover',
            delay: { show: 100, hide: 2000 },
            content: function(){
                var tracking_no = $(this).attr("tracking_no");
                var ship_type = $(this).attr("data-ship-type").toLowerCase();
                var old_tracking_no = false;
                var attr = $(this).attr('old_tracking_no');
                var html = '';
                if(typeof attr !== typeof undefined && attr !== false){
                    old_tracking_no = $(this).attr('old_tracking_no');
                    html = 'New ';
                }
                switch(ship_type)
                {
                    case "ics":
                        html += "ICS Tracking # <a target='_blank' href='http://www.icscourier.ca/online-services/tracking.aspx?trackNums=" + tracking_no + "'>" + tracking_no + "</a>";
                        if(old_tracking_no){
                            html += "<br> Old ICS Tracking # <a target='_blank' href='http://www.icscourier.ca/online-services/tracking.aspx?trackNums=" + old_tracking_no + "'>" + old_tracking_no + "</a>";
                        }
                        return html;
                    break;
                    case "fedex":
                        html += "FedEx Tracking # <a target='_blank' href='https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber=" + tracking_no + "'>" + tracking_no + "</a>";
                        if(old_tracking_no){
                            html += "<br> Old FedEx Tracking # <a target='_blank' href='https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber=" + old_tracking_no + "'>" + old_tracking_no + "</a>";
                        }
                        return html;
                    break;
                    case "ups":
                        html += "UPS Tracking # <a target='_blank' href='http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=" + tracking_no + "'>" + tracking_no + "</a>";
                        if(old_tracking_no){
                            html += "<br> Old UPS Tracking # <a target='_blank' href='http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=" + old_tracking_no + "'>" + old_tracking_no + "</a>";
                        }
                        return html;
                    break;
                }

            }
        });
        $(".make-switch").bootstrapSwitch();
    });
    // $(window).resize(function(){
    //     windowResize();
    // });
    $(document).ajaxSend(function(r, s) {
        if(blockUIFlag && window.isLoaderFStop == false){
            // App.blockUI({animate:!0});
            $loading.show();
        }
        else
            $('.table-loader').removeClass('chide');

        blockUIFlag = true;
    });
    $(window).bind('beforeunload', function(){
      $loading.show();
    });
    if ($('.date-picker').length > 0) {
        $('.date-picker input').datepicker({
            autoclose: true,
            'format': 'yyyy-mm-dd',
            orientation: 'bottom'
        });
    }   
    if ($('#date_range').length > 0) {
        window.dateRangePicker = flatpickr('#date_range', {
            mode: 'range',
            dateFormat: 'm/d/Y',
            onChange: function(selectedDates, dateStr, instance) {
                if (selectedDates.length === 2) {
                    $('#from_date').val(instance.formatDate(selectedDates[0], 'Y-m-d'));
                    $('#to_date').val(instance.formatDate(selectedDates[1], 'Y-m-d'));
                }
            }
        });
    }

      /*****************************Start Scroll Part*****************************/

    // Ladda.bind("#load-more-btn");

    $('#load-more-btn').hide();
    $('.dt-more-container').append('<div class="table-loader chide">Loading...</div>');

    $('#load-more-btn').on('click',function(e){
        var attr = $(this).attr('disabled');
        if(typeof attr === typeof undefined){
            blockUIFlag = false;
            var tableClass = $(this).attr('data-attr');
            var tableElement = $('.'+tableClass);
            var element = $(this);
            var currentPage = parseInt(tableElement.find('table').attr('data-page')) || 1;
            var url = $('#orders_search_form').attr('action');
            var data = $('#orders_search_form').serializeArray();
            data.push({ name: 'page-no', value: currentPage + 1 });
            data.push({ name: 'records-per-page', value: getPageSize(0) });
            var queryParams = getQueryParameters();
            if(queryParams.order){
                isSelectedOrderOpened = true;
                data.push({ name: 'order', value: queryParams.order });
            }
            loadMoreAjaxPost(element,tableElement,url,data);
        }
    });
    /*****************************End Scroll Part*****************************/
    $(document).on('click','.rx_create_another',function(){
        id = $(this).attr('data-id');
        if(confirm('Are you sure you want to create another order for this patient?')){
            $.ajax({
                url: 'copy',
                type: "POST",
                data: {id:id,_token: $('meta[name="csrf-token"]').attr('content')},
                success: function(data){
                    if(data.status){
                        window.location.replace("show/"+data.id);
                        toastMessage('success',data.message);
                    }
                    else
                        toastMessage('error',data.message);
                }
            });
        }
    });

    $(document).on('keyup','.write_msg',function(e){
        if(e.keyCode == 13)
            $('.msg_send_btn').trigger('click');
    });
    $(document).on('click','.add_comment',function(){
        $('.modal-user-messages').empty();
        id = $(this).attr('data-id');
        type = $(this).attr('data-attr');
        if(type == 'orders')
            $('#stack1').find('.logs-modal-header .modal-title').text('Comments (Order # '+id+')');
        else{
            name = $(this).attr('data-name');
            $('#stack1').find('.logs-modal-header .modal-title').text('Phone Call Logs ('+name+')');
        }

        $('.msg_send_btn').attr('data-attr', type);
        $('.msg_send_btn').attr('data-id', id);
        getCMessages(id,type);
    });
    $(document).on('click','.msg_send_btn', function(e){
        if ($(this).attr('data-attr') == 'orders') {
            storeLog('orders',$(this).attr('data-id'));
        } else{
            storeLog('phone',null,$(this).attr('data-id'));
        }
    });
    $(document).on('click','.print_order-btn', function(e){
        if ($(this).attr('data-url') != '') {
            var $button = $(this);
            var originalText = $button.text();
            var url = $(this).attr('data-url');

            if (url.indexOf('upload-print') !== -1) {
                // Handle upload-print with AJAX
                $button.text('Sending...').prop('disabled', true);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {_token: $('meta[name="csrf-token"]').attr('content')},
                    success: function(data){
                        if(data.status){
                            toastMessage('success',data.message);
                        }else{
                            toastMessage('error',data.message);
                        }
                        $button.text(originalText).prop('disabled', false);
                    },
                    error: function(xhr, status, error) {
                        toastMessage('error', 'Failed to upload PDF to Dropbox');
                        $button.text(originalText).prop('disabled', false);
                    }
                });
            } else if (url.indexOf('print-pdf') !== -1) {
                // Handle print-pdf with popup (no action=print parameter)
                window.open(url, "popupWindow", "width=738, height=720, scrollbars=yes");
            } else {
                // Handle regular print with popup
                window.open(url+'?action=print', "popupWindow", "width=738, height=720, scrollbars=yes");
            }
            return false;
        }
    });
    $(document).on('click','.print_local_order-btn', function(e){
        if ($(this).attr('data-id') != '') {
            var orderId = $(this).attr('data-id');
            var url = baseUrl+'/orders/upload-print/'+orderId;
            $.ajax({
                url: url,
                type: "GET",
                success: function(data){
                    if(data.status){
                        toastMessage('success',data.message);
                    }else{
                        toastMessage('error',data.message);
                    }
                }
            });
        }
    });

    // User search functionality
    $(document).on('click', '#search_button', function (event) {
        event.preventDefault();
        const $searchButton = $(this);
        const originalButtonText = $searchButton.html();

        // Disable button and show loading state
        $searchButton.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Loading...');

        const $form = $('#orders_search_form');
        const url = $form.attr('action');
        const data = $form.serializeArray();
        data.push({ name: 'page-no', value: 1 });
        data.push({ name: 'records-per-page', value: 200 });

        $.ajax({
            url: url,
            type: 'POST',
            data: $.param(data),
            success: function (response) {
                if (response && response.html) {
                    const tbodyContent = $(response.html).find('tbody').html();
                    if (tbodyContent) {
                        $('#records-container tbody').html(tbodyContent);
                    }
                }

                $searchButton.prop('disabled', false).html(originalButtonText);

                // Update total records
                const totalRecordsField = document.querySelector('#total-records');
                if (totalRecordsField) {
                    totalRecordsField.value = response.totalRecords || 0;
                }

                // Scroll to top
                const scrollableContainer = document.querySelector('.adjust_height-container');
                if (scrollableContainer) {
                    scrollableContainer.scrollTop = 0;
                }
            },
            error: function (error) {
                console.error('Error during search:', error);
                $searchButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });

    // User clear search functionality
    $(document).on('click', '#reset_search', function(event) {
        event.preventDefault();

        const $clearButton = $(this);
        const originalButtonText = $clearButton.html();
        $clearButton.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Clearing...');

        // Clear all text inputs and textareas in the form
        $('#orders_search_form').find("input[type=text], textarea").val("");

        // Clear Flatpickr date range picker
        if (window.dateRangePicker) {
            window.dateRangePicker.clear();
        }

        // Clear hidden date fields
        $('#from_date').val('');
        $('#to_date').val('');

        // Clear the user type select2 dropdown
        if ($('#orders_search_form select[name="status[]"]').data('select2')) {
            $('#orders_search_form select[name="status[]"]').val(null).trigger('change');
        }

        // Clear order info and show default message
        $('#tab_order').html('<center><h3>Click to view <i class="fa fa-shopping-cart" aria-hidden="true"></i></h3></center>');

        // Make sure the order tab is active
        $('.nav-tabs a[href="#tab_order"]').tab('show');

        // Remove print buttons
        $('.print-btn-container').empty();

        // Scroll order list to top
        const scrollableContainer = document.querySelector('.adjust_height-container');
        if (scrollableContainer) scrollableContainer.scrollTop = 0;

        // Trigger search to reload all data
        const url = $('#orders_search_form').attr('action');
        const data = $('#orders_search_form').serializeArray();
        data.push({ name: 'page-no', value: 1 });
        data.push({ name: 'records-per-page', value: 200 });

        $.ajax({
            url: url,
            type: 'POST',
            data: $.param(data),
            success: function (response) {
                if (response && response.html) {
                    const tbodyContent = $(response.html).find('tbody').html();
                    if (tbodyContent) {
                        $('#records-container tbody').html(tbodyContent);
                    }
                }

                $clearButton.prop('disabled', false).html(originalButtonText);

                // Update total records
                const totalRecordsField = document.querySelector('#total-records');
                if (totalRecordsField) {
                    totalRecordsField.value = response.totalRecords || 0;
                }
            },
            error: function (error) {
                console.error('Error during clear:', error);
                $clearButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
    $(document).on('click', '.get_email_templates', function (e) {
        order_id = $(this).attr('data-id');
        $('.templates_modal').attr('data-order-id',order_id);
    });

    $(document).on('click', '.send-email' ,function (e) {
        order_id = $('.templates_modal').attr('data-order-id');
        url = $(this).attr('data-url');
        template_id = $(this).attr('data-id');
        sendEmailToCustomer(template_id,order_id);
    });

    $(document).on('click', '.show-email-template', function (e) {
        id = $(this).attr('data-id');
        showEmailTemplate(id);
    });
    $(document).on('click','.read_all_notifications', function (e) {
        url = $(this).attr('data-url');
        customerReadsAllNotifications(url);
    });

    // Handle notification redirect
    var queryParams = getQueryParameters();
    if (queryParams.order && queryParams.from === 'notification') {
        var orderId = queryParams.order;
        var url = baseUrl + '/common/details-api/' + orderId;
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                var $data = $(data.order);
                $('.order-details-container #tab_order').html('');
                $('.order-details-container #tab_invoice').html('');
                $('.order-details-container #comment-box').hide();
                $('.order-details-container #tab_order').append($data);
                $('.noti_counter-span').hide();
                $('.noti_counter-span').text(data.notifications_count);
                if(data.notifications_count > 0){
                    $('.noti_counter-span').show();
                }
                $('#comment-tab-wrapper').html('');
                if(data.comments && data.comments != ''){
                    $('.tab-pane #cmt_order_id').val(orderId);
                    updateActionButtonsVisibility();
                    $('.order-details-container #comment-box').show();
                    $('#comment-tab-wrapper').html(data.comments);
                }
                // Activate tab_comments
                $('.nav .tab_comments').trigger('click');
            }
        });
    }
    var customButtons = {};
    customButtons['orderId'] = ['{!order_id!}','Order ID'];
    customButtons['orderUrl'] = ['{!order_url!}','Order Url'];
    customButtons['firstName'] = ['{!firstName!}','First Name'];
    customButtons['lastName'] = ['{!lastName!}','Last Name'];
    customButtons['invoiceNumber'] = ['{!invoiceNumber!}','Invoice Number'];
    customButtons['customerBusinessName'] = ['{!customerBusinessName!}','Customer Business Name'];
    customButtons['businessAddress'] = ['{!businessAddress!}','Business Address'];
    customButtons['phone'] = ['{!phone!}','Phone'];
    customButtons['email'] = ['{!email!}','Email'];
    customButtons['fax'] = ['{!fax!}','Fax'];
    customButtons['actualMessage'] = ['{!actualMessage!}','Actual Message'];
    customButtons['patientName'] = ['{!patientName!}','Patient Name'];
    CKEDITOR.config.extraPlugins = 'orderid';
    CKEDITOR.plugins.add( 'orderid', {
        init: function( editor ) {
            $.each(customButtons, function( index, value ) {
                editor.addCommand( index, {
                    exec: function( editor ) {
                        var now = new Date();
                        editor.insertHtml( value[0] );
                    }
                });
                editor.ui.addButton( index, {
                    label: value[1],
                    command: index,
                    toolbar: 'about'
                });
            });
        }
    });
    CKEDITOR.on('instanceReady', function() {
        $(".cke_button__orderid_icon").text("Order ID");
        $(".cke_button__orderurl_icon").text("Order Url");
        $(".cke_button__firstname_icon").text("First Name");
        $(".cke_button__lastname_icon").text("Last Name");
        $(".cke_button__invoicenumber_icon").text("Invoice Number");
        $(".cke_button__customerbusinessname_icon").text("Customer Business Name");
        $(".cke_button__actualmessage_icon").text("Actual Message");
        $(".cke_button__businessaddress_icon").text("Business Address");
        $(".cke_button__phone_icon").text("Phone");
        $(".cke_button__email_icon").text("Email");
        $(".cke_button__fax_icon").text("Fax");
        $(".cke_button__patientname_icon").text("Patient Name");

        $(".cke_button__orderid").css("width",'40px');
        $(".cke_button__orderurl").css("width",'51px');
        $(".cke_button__firstname").css("width",'53px');
        $(".cke_button__lastname").css("width",'53px');
        $(".cke_button__invoicenumber").css("width",'79px');
        $(".cke_button__customerbusinessname").css("width",'135px');
        $(".cke_button__businessaddress").css("width",'91px');
        $(".cke_button__phone").css("width",'29px');
        $(".cke_button__email").css("width",'26px');
        $(".cke_button__fax").css("width",'15px');
        $(".cke_button__actualmessage_icon").css("width",'84px');
        $(".cke_button__patientname_icon").css("width",'78px');
    });

    sidebarSearch();
    if($('.enable_change_btn').length > 0){
        $('form.enable_change_btn').find(':input[type=submit]').prop('disabled',true);
        $('form.enable_change_btn').find('.btn_cancel').addClass('disabled');
        $("form.enable_change_btn").on('keyup change switchChange.bootstrapSwitch',function(){
            $(this).find(':input[type=submit]').prop('disabled',false);
            $(this).find('.btn_cancel').removeClass('disabled');
        });
    }
    $(document).on('click', '.split-table tbody tr' ,function (e) {
        var orderId = $(this).attr('data-id');
        var type = $('.split-table').attr('data-type');
        var url = baseUrl+'/common/details-api/'+orderId;

        if(typeof type != 'undefined')
            url += '/'+type;

        $('.split-table tbody tr').removeClass('active');
        $(this).addClass('active');
        let element = $(this);
        console.log('Clicked order ID:', orderId);
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                var $data = $(data.order);
                $('.order-details-container #tab_order').html('');
                $('.order-details-container #tab_invoice').html('');
                $('.order-details-container #comment-box').hide();
                $('.order-details-container #tab_order').append($data);
                $('.noti_counter-span').hide();
                $('.noti_counter-span').text(data.notifications_count)
                if(data.notifications_count > 0){
                    $('.noti_counter-span').show();
                }
                if(element.hasClass('selected')){
                    var queryParams = getQueryParameters();
                    if(queryParams.tab && queryParams.tab =='view'){
                        $('.nav .tab_order').trigger('click');
                    }else{
                        $('.nav .tab_comments').trigger('click');
                    }
                    element.removeClass('selected');
                }else{
                    $('.nav .tab_order').trigger('click');
                }
                // Clear and load comments for the selected order
                $('#comment-tab-wrapper').html('');
                if(data.comments && data.comments != ''){

                    $('.tab-pane #cmt_order_id').val(orderId);

                    updateActionButtonsVisibility();

                    $('.order-details-container #comment-box').show();

                    $('#comment-tab-wrapper').html(data.comments);

                }
                if(type == 'users'){
                    $('.order-list .order-details-container').find('.data-tabs.permissions').attr('data-toggle','tab');
                    if(typeof data.meta_data != 'undefined'){
                        $('#staff_user_id').val(data.meta_data.id);
                        $('#permission_order_placed').prop('checked', data.meta_data.permission_order_placed);
                        $('#permission_prices_invoices').prop('checked', data.meta_data.permission_prices_invoices);
                    }
                }else{
                    // updateOrderDetailButtons();
                }
                // var $data = $(data.comments);
                // $('.order-details-container #tab_comments').append($data);
                // var $data = $(data.invoice);
                // $('.order-details-container #tab_invoice').append($data);
            }
        });
        if(window.isLoaderStop && $.active == 0) $loading.hide();
    });
   
    // Handle tab clicks for invoice and comments
    $(document).on('click', '[data-id="tab_invoice"], [data-id="tab_comments"]' ,function (e) {
        var type = $(this).attr('data-value');
        var elemId = $(this).attr('data-id');
        var callRequired = false;
        var data = {};
        var html = '<p><center>No record found!</center></p>';
        console.log('DEBUG: Tab clicked, type:', type, 'elemId:', elemId);

        switch(type){
            case 'invoice':
                var  element = $('#tab_order input[name="invoice_order_no"]');
                var invoiceNo = element.val();
                console.log('DEBUG: Invoice order no element length:', element.length, 'value:', element.val());
                if(element.length > 0 && element.val() != ''){
                    data = {
                        id:invoiceNo,
                        type:type,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    };
                    callRequired = true;
                }else{
                    html = '<center><h3>No invoice found with order status</h3></center>';
                }
                // Activate the invoice tab
                $('.nav-tabs a[href="#tab_invoice"]').tab('show');
            break;
            case 'comments':
                // Comments are already loaded when order is selected
                // Just ensure the tab is activated
                $('.nav-tabs a[href="#tab_comments"]').tab('show');
                return; // Don't proceed with AJAX
            break;
        }
        if(callRequired){
            console.log('DEBUG: Making AJAX call for type:', type);
            $loading.show();
            $.ajax({
                url: baseUrl+'/orders/details-type-api',
                data: data,
                type: "POST",
                success: function(response){
                    console.log('DEBUG: AJAX response for type:', type, 'status:', response.status);
                    if(response.status){
                        if(response.metaData != ''){
                            if(type == 'invoice')
                                html = '<object data="'+response.metaData+'" type="application/pdf" style="height: 100%; width: 100%;"><iframe src="'+response.metaData+'" style="height: 100%; width: 100%;"></iframe></object>';
                        }
                    }
                    $('#'+elemId).html('');
                    $('#'+elemId).append(html);
                    $loading.hide();
                    // if(type == 'comments') autoHideDeleteBtn();
                }
            });
        }else{
            if(type == 'comments' && $('#'+elemId).find('.comment-list').length > 0){
                console.log('DEBUG: Comments already loaded, skipping AJAX');
                // Comments already loaded, don't replace
            }else if(type != 'comments'){
                console.log('DEBUG: No data to load for type:', type);
                $('#'+elemId).html('');
                $('#'+elemId).append(html);
            }
        }
    });
    $(document).on('click','.redo_order-btn',function(e){
        $('#start_redo_order-form').find('input[name="id"]').val($(this).attr('data-id'));
        $('#start_redo-modal').modal('show');
    });
    $('.comment-desc-p').linkify({
        target:"_blank"
    });
    $(".hover-open-list").mouseenter(function(e){
        if(!$(this).hasClass('show')){
            $(this).addClass('show');
        }
    }).mouseleave(function(e){
        if($(this).hasClass('show')){
            $(this).removeClass('show');
        }
    });

});


function getQueryParameters() {
    var queryString = window.location.search.substring(1);
    var queryParams = {};

    if (queryString) {
        var pairs = queryString.split("&");

        for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i].split("=");
            var key = decodeURIComponent(pair[0]);
            var value = decodeURIComponent(pair[1] || "");

            queryParams[key] = value;
        }
    }

    return queryParams;
}

function openSelectedOrder(){
    if($('.order-list').length > 0){
        if($('.order-list').find('.split-table tr.selected').length > 0){
            $('.order-list').find('.split-table tr.selected').trigger('click');
        }
    }
}

function initializationFn(){
    openSelectedOrder();
    if($('.split-table').length > 0){
        blockUIFlag = false;
        var tableElement = $('.'+$('#load-more-btn').attr('data-attr'));
        element = $('#load-more-btn');
        var url = $('#orders_search_form').attr('action');
        var data = $('#orders_search_form').serializeArray();
        data.push({ name: 'page-no', value: 1 });
        data.push({ name: 'records-per-page', value: getPageSize(0) });
        var queryParams = getQueryParameters();
        if(!isSelectedOrderOpened && queryParams.order){
            isSelectedOrderOpened = true;
            data.push({ name: 'order', value: queryParams.order });
        }
        loadMoreAjaxPost(element,tableElement,url,data);
    }
}

function getPageSize(count){
    count = parseInt(count);
    // Assuming each row is about 42px high, calculate how many pages of 20 records each
    // But actually, we need to increment page number properly for pagination
    // The count is the current page number, so return count + 1 for next page
    return count + 1;
}


function syncPageData(data){
    selectedID = 0;
    if($('.split-table tr.active').length > 0){
        selectedID = parseInt($('.split-table tbody tr.active').attr('data-id'));
    }
    console.log(selectedID);
    let notificationsCount = 0;
    if($('.order-details-container').length > 0 && selectedID == data.order_id){
        switch(data.type){
            case 'comment':
                if($('.tab_comments').parent().hasClass('active')){
                    $('.comment-list #empty-txt').remove();
                    $('#cmnt-remove-empty-txt').hide();
                    if($('.comment_'+data.id).length > 0){
                        $('.comment_'+data.id).replaceWith(data.html);
                    }else{
                        $('.comment-list').prepend(data.html);
                    }
                }
            break;
            case 'update_comment':
                if($('.tab_comments').parent().hasClass('active')){
                    $('.comment_'+data.id).replaceWith(data.html);
                }
            break;
            case 'reply':
                if($('.tab_comments').parent().hasClass('active')){
                    $('.comment_'+data.id).replaceWith(data.html);
                    // $('.comment_'+data.id).find('.todo-comment').append(data.html);
                }
            break;
            case 'delete_comment':
                if($('.tab_comments').parent().hasClass('active')){
                    $('.comment_'+data.id).remove();
                }
            break;
        }
        if(data.is_notify){
            notificationsCount = parseInt($('.noti_counter-span').text());
            notificationsCount += 1;
            $('.noti_counter-span').show();
            $('.noti_counter-span').text(notificationsCount);
        }
    }
    if(data.is_notify){
        if($('.navbar-fixed-top #notification-header-link .notifications-badge-counter').length > 0){
            notificationsCount = parseInt($('.navbar-fixed-top #notification-header-link .notifications-badge-counter').text()) + 1;
            $('.navbar-fixed-top #notification-header-link .notifications-badge-counter').text(notificationsCount);
        }else{
            html = '<span class="badge badge-danger notifications-badge-counter">1</span>';
            $('.navbar-fixed-top #notification-header-link a').prepend(html);
        }
        if($('#tr_order-'+data.order_id).length > 0){
            notificationsCount = parseInt($('#tr_order-'+data.order_id).find('.order_notification-counter').text()) + 1;
            $('#tr_order-'+data.order_id).find('.order_notification-counter').show();
            $('#tr_order-'+data.order_id).find('.order_notification-counter').text(notificationsCount);
        }
    }
}
function syncAdminPageData(data){
    switch(data.type){
        case 'csv_imported':
            if($('.cron-alert').length > 0){
                $('.cron-alert').remove();
            }
        break;
    }
}


// function windowResize() {
//     const portal = typeof portalType !== 'undefined' ? portalType : '';
//     let TOP_OFFSET = 81;
//     let TAB_AREA_OFFSET = (portal === 'customer' ? 276 : 300);
//     let TAB_PANE_EXTRA_OFFSET = 60;

//     const windowHeight = $(window).height();
//     const $tabContent = $('.tab-content');

//     if ($tabContent.length > 0 && typeof $tabContent.attr('data-height-set') === 'undefined') {
//         const tabPaneHeight = windowHeight - TAB_AREA_OFFSET;
//         const expandedContainerHeight = tabPaneHeight + TAB_PANE_EXTRA_OFFSET;
//         const commentWrapperHeight = tabPaneHeight - TAB_PANE_EXTRA_OFFSET;

//         $('.tab-pane').css('height', tabPaneHeight + 'px');
//         $('.set-document-height, .adjust_height-container').css('height', expandedContainerHeight + 'px');
//         $('#comment-tab-wrapper').css('height', commentWrapperHeight + 'px');
        
//         if (typeof updateOrderDetailButtons === 'function') {
//             updateOrderDetailButtons();
//         }
//         $tabContent.attr('data-height-set', 'true');
//     }

//     const pageContentHeight = windowHeight - TOP_OFFSET;
//     $('.page-content').css({
//         'height': pageContentHeight + 'px',
//         'min-height': pageContentHeight + 'px'
//     });

//     updateOrderDetailButtons(); // Update on resize
// }



    // function updateOrderDetailButtons() {
    //     if ($('.order-view-container').length > 0) {
    //         const portal = typeof portalType !== 'undefined' ? portalType : '';
    //         const TOP_OFFSET = 81; // Header height
    //         const TAB_AREA_OFFSET = (portal === 'customer' ? 470 : 470); // Adjust for tabs or other fixed elements
    //         const windowHeight = $(window).height();
    //         // const windowHeight = 919;
    //         const containerHeight = windowHeight - TOP_OFFSET - TAB_AREA_OFFSET; // Adjusted height
    //         console.group('order page list information')
    //         console.log('portal: ', portal)
    //         console.log('TAB_AREA_OFFSET: ', TAB_AREA_OFFSET)
    //         console.log('windowHeight: ', windowHeight)
    //         console.log('containerHeight: ', containerHeight)
    //         console.groupEnd();
    //         $('.order-view-container').css({
    //             'height': containerHeight + 'px',
    //             'max-height': containerHeight + 'px', // Prevent exceeding calculated height
    //             'overflow-y': 'auto' // Enable vertical scrolling
    //         });
    //     }
    // }

function sendEmailToCustomer(template_id,order_id) {
    swal({
        title: "Do you want to send email?",
        text:  'Send Email!',
        type: "info",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Yes",
        cancelButtonText: "No",
        closeOnConfirm: false,
        closeOnCancel: false,
    }, function(isConfirm){
      if (isConfirm) {
          $.ajax({
            url: $('#templates_modal').attr('data-email-url'),
            type: "POST",
            data: {template_id:template_id,order_id:order_id,_token: $('meta[name="csrf-token"]').attr('content')},
            success: function(data){
                swal({
                    html:true,
                    title:"Email Sent",
                    text: 'Email sent successfully',
                    type: "success"
                });
            }
        });
      } else {
          swal("Cancelled", "Email not sent!", "error");
      }
  });
}

function showEmailTemplate(id) {

    $.ajax({
        url: $('.show-email-template').attr('data-show-url'),
        type: "GET",
        data: {id:id,_token: $('meta[name="csrf-token"]').attr('content')},
        success: function(data){
            $('.show-teamplte-container').empty();
            $('.show-teamplte-container').append(data);
        }
    });
}
function customerReadsAllNotifications(url) {
    $.ajax({
        url: url,
        type: "POST",
        data: {_token: $('meta[name="csrf-token"]').attr('content')},
        success: function(){
            $('.page-header').find('.read_only').removeClass('read_only');
            $('.page-header').find('#notification_badge').removeClass('badge badge-default');
            $('.page-header').find('#notification_badge').text('');
            $('.page-header').find('#unread_notifications').text('0');
            $('.page-header').find('.read_all_link').text('');
        }
    });
}


function sidebarSearch() {
    var options = {
        valueNames: [ 'nav-link' ]
    };

    var linksList1 = new List('list1', options);
    var linksList2 = new List('list2', options);
    var linksList3 = new List('list3', options);
    var linksList4 = new List('list4', options);

    $('#sidebarSearching').on('keyup',function() {
        var searchString = $(this).val().toLowerCase();
        linksList1.search(searchString);
        linksList2.search(searchString);
        if($('#list3').length > 0)
            linksList3.search(searchString);
        if($('#list4').length > 0)
            linksList4.search(searchString);

        for (var i = 1; i <= 4; i++) {
            if($('#list'+i+' ul').find('li').length < 1)
                $('#list'+i).addClass('hide');
            else
                $('#list'+i).removeClass('hide');
        }

        $.each($('.pnav-item'), function( index, value ) {
            var str = $(this).find('.title').text().toLowerCase();
            if(str.search(searchString) !== -1)
                $(this).removeClass('hide');
            else
                $(this).addClass('hide');
        });
    });
}
function storeLog(log_type,order_id,user_to){
    var description = $('.write_msg').val();
    if(description != ''){
        $.ajax({
            url: $('#stack1').attr('data-store'),
            type: "POST",
            data: {type:log_type,order_id:order_id,user_to:user_to,description:description, _token: $('meta[name="csrf-token"]').attr('content')},
            success: function(data){
                $('.write_msg').val('');
                $('#modal-user-messages').append(data);
                $('.logs-modal-body').animate({scrollTop:$('.logs-modal-body').height()});
            }
        });
    }
}
function getCMessages(order_id,type) {
    $.ajax({
        url: $('#stack1').attr('data-url'),
        type: "POST",
        data: {type:type,order_id:order_id, _token: $('meta[name="csrf-token"]').attr('content')},
        success: function(data){
            $('.modal-user-messages').append(data);
            $('.logs-modal-body').animate({scrollTop:$('.logs-modal-body').height()});
        }
    });
}
function printErrorMsg (msg) {
    var text = '';
    var level = 'error';
    $.each( msg, function( key, value ) {
        text += value+'<br>';
    });
    toastMessage(level,text);
}
function toastMessage(level,text){
    if(text != '' && level != ''){
        switch(level){
            case 'success':
                toastr.success(text)
            break;
            case 'error':
                toastr.error(text)
            break;
            case 'info':
                toastr.info(text)
            break;
            case 'warning':
                toastr.warning(text)
            break;
        }
    }
}

function loadMoreAjax(element,tableElement,urlParam){
    $.ajax({
        url: urlParam,
        type: "GET",
        success: function(data){
            var $data = $(data);
            tableElement.fadeOut().html($data).fadeIn();
            // Ladda.stopAll();
            setTimeout(function(){
                openSelectedOrder();
                if(tableElement.find('table').attr('data-more') == 'no'){
                    element.prop('disabled', true);
                    // Remove scroll event listener when no more data
                    $('.nscroller').each(function(){
                        $(this)[0].removeEventListener('scroll', debouncedScroll);
                    });
                }
            }, 500);
        }
    });
}

function loadMoreAjaxPost(element,tableElement,url,data){
    $.ajax({
        url: url,
        type: "POST",
        data: $.param(data),
        success: function(response){
            if (response && response.html) {
                const tbodyContent = $(response.html).find('tbody').html();

                if (tbodyContent) {
                    tableElement.find('tbody').append(tbodyContent);
                    var currentPage = parseInt(tableElement.find('table').attr('data-page')) || 1;
                    tableElement.find('table').attr('data-page', currentPage + 1);

                    // Calculate total loaded records
                    var loadedRecords = tableElement.find('tbody tr').length;
                    var hasMore = loadedRecords < response.totalRecords;

                    tableElement.find('table').attr('data-more', hasMore ? 'yes' : 'no');

                    // Update total records
                    const totalRecordsField = document.querySelector('#total-records');
                    if (totalRecordsField) {
                        totalRecordsField.value = response.totalRecords || 0;
                    }
                }

                if(tableElement.find('table').attr('data-more') == 'no'){
                    element.prop('disabled', true);
                    element.hide();
                }
            }
        }
    });
}
