@extends('backend.layouts.split')

@section('title', 'Edit Api Client' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
    {{ html()->modelForm($apiClient, 'PATCH', route('admin.auth.api-client.update', $apiClient))->class('form-actions top')->open() }}
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        Api Client
                        <small class="text-muted">@lang('Edit')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Name')->class('control-label')->for('name') }}
                                    {{ html()->text('name')
                                            ->class('form-control')
                                            ->placeholder('Client Name')
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Rate Limit (requests per minute)')->class('control-label')->for('rate_limit') }}
                                    {{ html()->number('rate_limit')
                                            ->class('form-control')
                                            ->placeholder('60')
                                            ->required()
                                            ->attribute('min', 1) }}
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Current API Key')->class('control-label') }}
                                    {{ html()->text('token', $apiClient->token)
                                            ->class('form-control')
                                            ->readonly() }}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Regenerate Token')->class('col-md-4 control-label style-lable')->for('regenerate_token') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('regenerate_token', false)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Enabled')->class('col-md-4 control-label style-lable')->for('active') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('active', $apiClient->active)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.api-client.index'), __('buttons.general.cancel')) }}
                        {{ form_submit('Update') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection