@extends('frontend.layouts.print')

@section('title', 'Order #'.$order->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<table width="100%" align="left" cellpadding="0" cellspacing="0" border="0">
    <tbody>
        <tr>
            <td>
                <form name="OrderFrm" id="OrderFrm" method="post" action="">
                    <table width="450" cellpadding="0" cellspacing="0" border="0" align="center">
                        <tbody>
                            <tr>
                                <td valign="top" align="center">
                                    <div class="cropped">
                                        @php
                                            $string = $user->ac_code . "\x0D" . str_replace('#', '', $order->getOrderNumber()) . "\x0D" . $order->getOrderNumber();
                                        @endphp
                                        <img src="{{generateBarcode($string,40,3)}}" width="430px">
                                    </div>
                                    <div class="tableValueNames">
                                        {{ $user->ac_code }} {{ str_replace('#', '', $order->getOrderNumber()) }} {{ $order->getOrderNumber() }} 
                                    </div>
                                    <table width="450" cellpadding="0" cellspacing="0" border="0">
                                        <tbody>
                                        <tr>
                                            <td valign="top" width="25%"><img src="{{ URL::asset('public/img/backend/brand/logo.gif') }}" height="40" alt="" hspace="10"></td>
                                            <td valign="top" align="center"><h2 style="font-family:Arial, Verdana;margin:0px;" class="GriffonLight">Consumables Order</h2></td>
                                        </tr>
                                        <tr>
                                            {!! displayNewCustomerWarning($user->created_at, 'print') !!}
                                        </tr>
                                    </tbody>
                                    </table>
                                </td>
                            </tr>

                            <tr>
                                
                                <td><table width="450" cellpadding="1" cellspacing="0" border="0" class="tabletext">

                                    <tbody>
                                        <tr valign="top" class="rowtopborder">
                                            <td class="tableValueNames" width="15%" align="left">Account No.</td>
                                            <td valign="top" width="60%" align="left">
                                                <b>{{ $user->ac_code }} - {{ $profile->business_name }}</b>
                                                <div class="cropped3">
                                                <img src="{{ generateBarcode($user->ac_code) }}">                         
                                                </div>
                                            </td>
                                            <td valign="top" width="25%" align="center" rowspan="2">
                                                <span class="tableValueNames">Order No.</span>
                                                <br>
                                                <span style="font-size:18px"><b>{{ $order->getOrderNumber() }}</b></span>
                                                <div class="cropped2">
                                                <img src="{{ generateBarcode($order->getOrderNumber()) }}" width="70px">                         
                                                </div>
                                            </td>
                                        </tr>
                                        <tr valign="top">
                                            <td class="tableValueNames" align="left">Patient / Tray</td>
                                            <td valign="top" align="left">
                                                <b>{{ $order->getOrderNumber() }}</b>
                                                <div class="cropped3">
                                                    <img src="{{ generateBarcode($order->getOrderNumber()) }}">  
                                                </div>
                                            </td>
                                        </tr>
                                        <tr valign="top" class="rowbtmborder">
                                            <td class="tableValueNames" align="left">Date</td>
                                            <td valign="top" align="left"><b>{{ date_time_format($order->created_at,'d-M-Y h:i a')}}</b>
                                            </td>
                                            <td valign="top" align="middle">
                                            </td>
                                        </tr>
                                </tbody></table></td>
                            </tr>
                            <tr>
                                <td style="height:5px;"></td>
                            </tr>
                            <tr>
                                <td valign="top" align="center">
                                    <table width="450" cellpadding="0" cellspacing="0" border="1" style="border-collapse:collapse;">
                                        <tbody>
                                            <tr>
                                                <td align="left">
                                                    @foreach($order->consumableModals as $key => $value)
                                                    <table class="tabletext" width="450" cellpadding="0" cellspacing="0" border="0" style="{{  $key != 0 ? 'border-top: 1px solid;' : '' }}">
                                                        <tbody>
                                                            <tr>
                                                                <td valign="top" align="left">
                                                                    <b>{{ $value->getUpc() }}</b><br>
                                                                    <img src="{{ generateBarcode($value->getUpc(),35,3) }}" width="230px" height="40px">                                    
                                                                </td>
                                                                <td valign="top" align="center" style="width: 38px">Qty
                                                                <span style="display:block; border: 3px solid black; width: 28px" valign="top" align="center">
                                                                    <b style="font-size: 20px;">{{$value->quantity}}</b>
                                                                </span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <b>{{$value->name}} - {{$value->sub_name}}</b><br>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                    @endforeach
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </form>
            </td>
        </tr>
    </tbody>
</table>
@endsection