@extends('frontend.layouts.print')

@section('title', 'Order #'.$modal->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<table width="100%" align="left" cellpadding="0" cellspacing="0" border="0">
    <tbody>
        <tr>
            <td>
                <form name="OrderFrm" id="OrderFrm" method="post" action="orderSubmit.php">
                    <table width="450" cellpadding="0" cellspacing="0" border="0" align="center">
                        <tbody>
                            <tr>
                                <td valign="top" align="center">
                                    <div class="cropped">
                                        @php
                                            $string = $user->ac_code . "\x0D" . $stockOrder->order->patient . "\x0D" . $stockOrder->order->getOrderNumber();
                                        @endphp
                                        <img src="{{generateBarcode($string,40,3)}}" width="430px">   
                                    </div>
                                    <table width="450" cellpadding="0" cellspacing="0" border="0">
                                        <tbody>
                                            <tr>
                                            </tr>
                                            <tr valign="top">
                                                <td width="100%" class="tableValueNames" align="center" colspan="2">
                                                    {{ $user->ac_code }} {{ str_replace('#', '', $stockOrder->order->patient) }} {{ $stockOrder->order->getOrderNumber() }}                       
                                                </td>
                                            </tr>
                                            <tr height="60" valign="middle">
                                                <td width="25%"><img src="http://www.lens-shapers.com/images/logo.jpg" height="40" alt="" hspace="10"></td>
                                                <td align="center">
                                                    <h2 style="font-family:Arial, Verdana" class="GriffonLight">Stock Order</h2>
                                                </td>
                                            </tr>
                                            <tr>
                                                {!! displayNewCustomerWarning($user->created_at, 'print') !!}
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table width="450" cellpadding="1" cellspacing="0" border="0" class="tabletext">
                                        <tbody>
                                            <tr valign="top" class="rowtopborder">
                                                <td class="tableValueNames" width="15%" align="left">Account No.</td>
                                                <td valign="top" width="60%" align="left">
                                                    <b>{{ $user->ac_code }} - {{ $profile->business_name }}</b>
                                                    <div class="cropped3">
                                                        <img src="{{generateBarcode($user->ac_code)}}" width="70px">    
                                                    </div>
                                                </td>
                                                <td valign="top" width="25%" align="center" rowspan="2">
                                                    <span class="tableValueNames">Order No.</span>
                                                    <br>
                                                    <span style="font-size:18px"><b>{{ $stockOrder->order->getOrderNumber() }}</b></span>
                                                    <div class="cropped2">
                                                        <img src="{{generateBarcode($stockOrder->order->getOrderNumber())}}" width="70px">   
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr valign="top">
                                                <td class="tableValueNames" align="left">Patient / Tray</td>
                                                <td valign="top" align="left">
                                                    <b>{{ $stockOrder->order->patient }}</b>
                                                    <div class="cropped3">
                                                        <img src="{{generateBarcode($stockOrder->order->patient)}}" width="250px">  
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr valign="top" class="rowbtmborder">
                                                <td class="tableValueNames" align="left">Date</td>
                                                <td valign="top" align="left"><b>{{ date_time_format($stockOrder->order->created_at,'d-M-Y h:i a')}}</b>
                                                </td>
                                                <td valign="top" align="middle">
                                                </td>
                                            </tr>
                                            <!--<tr>
                                                td valign="top" align="left">Address</td>
                                                <td valign="top" align="left"><b> <br />  </b></td-->
                                            <!--<td class="tableValueNames" valign="top" align="left">Job Type</td>
                                                <td valign="top" align="left"><b></b></td>-->
                                            <!--<td>Status</td>
                                                <td><b>Received at Lab</b></td>
                                                </tr>-->
                                            <!--<tr> class='rowbtmborder'      <td>&nbsp;</td>
                                                <td><b></b>&nbsp;</td>
                                                </tr> -->
                                            <!---->
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td style="height:5px;"></td>
                            </tr>
                            <tr>
                                <td valign="top" align="center">
                                    <table width="450" cellpadding="0" cellspacing="2" border="1" style="border-collapse:collapse">
                                        <tbody>
                                            <tr>
                                                <td align="left">
                                                    <table class="tabletext" width="100%" cellpadding="2" cellspacing="0" border="0" style="padding: 5px; line-height: 1.8">
                                                        <tbody>
                                                            <tr align="left">
                                                                <td>Barcode</td>
                                                                <td>Sph</td>
                                                                <td>Cyl</td>
                                                                <td>Description</td>
                                                                <td align="middle">Qty</td>
                                                            </tr>        
                                                                @if( $stockOrder->isBoth() || $stockOrder->isRight() )
                                                                    <tr height="35px" align="left">
                                                                        <td class="position-relative">
                                                                            <img src="{{generateBarcode($stockOrder->r_barcode,40,3)}}" width="100px" height="40px">  
                                                                            <span class="barcode-text">{{ $stockOrder->l_barcode }}</span> 
                                                                        </td>
                                                                        <td style="white-space: nowrap;"><b>{{ $stockOrder->r_sph }}</b></td>
                                                                        <td style="white-space: nowrap;"><b>{{ $stockOrder->r_cyl }}</b></td>
                                                                        <td style="font-size:11px;">{{ $stockOrder->rightDetails() }}</td>
                                                                        <td align="middle"><b>{{ $stockOrder->r_quantity }}</b></td>
                                                                    </tr> 
                                                                @endif
                                                                @if( $stockOrder->isBoth() || $stockOrder->isBarcode() || $stockOrder->isLeft() )
                                                                    <tr align="left">
                                                                        <td class="position-relative">
                                                                            <img src="{{generateBarcode($stockOrder->l_barcode,40,3)}}" width="100px" height="40px"> 
                                                                            <span class="barcode-text">{{ $stockOrder->l_barcode }}</span> 
                                                                        </td>
                                                                        <td style="white-space: nowrap;"><b>{{ $stockOrder->l_sph }}</b></td>
                                                                        <td style="white-space: nowrap;"><b>{{ $stockOrder->l_cyl }}</b></td>
                                                                        <td style="font-size:11px;">{{ $stockOrder->leftDetails() }}</td>
                                                                        <td align="middle"><b>{{ $stockOrder->l_quantity }}</b></td>
                                                                    </tr> 
                                                                @endif
                                                                <tr>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td></td>
                                                                    <td align="right">Total:</td>
                                                                    <td align="middle"><b>{{ $stockOrder->l_quantity + $stockOrder->r_quantity }}</b></td>
                                                                </tr>
                                                        </tbody>
                                                    </table>
                                                    @if($stockOrder->allCards)
                                                    <table class="tabletext" width="100%" cellpadding="2" cellspacing="0" border="0" style="padding: 5px; line-height: 1.8; margin-top: 30px;">
                                                        <tr>
                                                            <td>Authenticity Cards:</td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <?
                                                                $rightCards = explode("|", $stockOrder->r_cards);
                                                                $leftCards = explode("|", $stockOrder->l_cards);
                                                                $allCards = array_merge($rightCards, $leftCards);
                                                                $allCards = array_unique($allCards);

                                                                foreach ($allCards as $card) {
                                                                    ?>
                                                                    <div style="border: 3px solid black; display: inline-block; padding: 5px;"><? echo $card ?></div>
                                                                    <?
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    @endif
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </form>
            </td>
        </tr>
    </tbody>
</table>
@endsection