@extends('backend.layouts.split')

@section('title', 'Stock Lens' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())
@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-basket font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Stock Lens </span>
                </div>
            </div>
            <div class="portlet-body">
                @include('backend.auth.orders.includes.orders-search-form', compact('orders', 'pageCount', 'models'))
                <div class="table-data-container" style="margin-top:5%">
                    @include('partials.orderlist', ['orders' => $orders, 'pageCount' => $pageCount, 'isBackend' => true])
                </div>
                <div class="dt-more-container text-center">
                    <button type="button" class="btn blue mt-ladda-btn ladda-button btn-outline btn-circle" id="load-more-btn" data-style="slide-up" data-spinner-color="#333" data-attr="table-data-container" <?= (!$orders->hasMorePages()) ? 'disabled' : '' ?>>
                        <span class="ladda-label"> <i class="icon-arrow-down"></i>  Load More</span>
                        <span class="ladda-spinner"></span>
                    </button>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
<div class="modal fade" id="barcode-modal" tabindex="-1" role="basic" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Stock Lens Order (Search by Barcode)</h4>
            </div>
            <div class="modal-body">
                {{ html()->form('POST', route('frontend.new-barcode'))->attribute('id','barcode-form')->attribute('class','form-horizontal form-row-seperated')->open() }}
                    <input type="hidden" name="type" value="barcode">
                    <input type="hidden" name="id" value="" id="id">
                    <div class="form-body">
                        <div class="form-group">
                            <div class="col-md-2"></div>
                            <div class="col-md-8">
                                <div class="input-group">
                                    <input class="form-control" id="mask_phone" type="text" />
                                    <span class="input-group-btn">
                                        <button class="btn default" id="search-btn" type="button">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group" id="barcode-container">
                        </div>
                    </div>
                {{ html()->form()->close() }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                <button type="button" class="btn green btn-order-submit">Order</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@include('backend.auth.templates.includes.templates-modal')
@include('backend.auth.orders.includes.side-panel')
@endsection
@push('after-scripts')
<script>   
    var url = "<?= route('admin.search-barcode-api') ?>";
    var html = '';
    $(function() {
        $("#mask_phone").inputmask({mask:"9999 999999"});
        $('#barcode-form').submit(function(e){
            search();
            e.preventDefault();
        });
        $('#search-btn').on('click',function(e){
            search();
        });
        $('.btn-order-submit').on('click',function(e){
            saveOrder();
        });
    });
    function search(){

        value = $('#mask_phone').val();
        if(value != ''){
            // App.blockUI({target:"#barcode-container",overlayColor:"none",animate:!0});
            $.ajax({
                url: url,
                type: "POST",
                data: {'value':value,_token: '{{csrf_token()}}'},
                success: function(data){
                    // App.unblockUI({target:"#barcode-container"});
                    if(data.status){
                        $('#id').val(data.data.id);
                        html = '<div class="row static-info"><div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> Material: </div>';
                            html += '<div class="col-md-7 value">'+data.data.material+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> Colour: </div>';
                            html += '<div class="col-md-7 value">'+data.data.colour+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> Coating: </div>';
                            html += '<div class="col-md-7 value">'+data.data.coating+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> SPH: </div>';
                            html += '<div class="col-md-7 value">'+data.data.sph+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> CYL: </div>';
                            html += '<div class="col-md-7 value">'+data.data.cyl+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> Size: </div>';
                            html += '<div class="col-md-7 value">'+data.data.size+'</div>';
                        html += '</div>';
                        html += '<div class="col-md-6 barcode-info">';
                            html += '<div class="col-md-5 name"> Price: </div>';
                            html += '<div class="col-md-7 value"><span class="label label-info label-sm">$'+data.data.price+'</span></div>';
                        html += '</div></div>';
                        $('#barcode-container').empty();
                        $('#barcode-container').append(html);
                    }
                }
            });
        }
    }
    function saveOrder(){
        swal({
              title: "Do you want to make an order?",
              text:  'New Order!',
              type: "info",
              showCancelButton: true,
              confirmButtonColor: "#DD6B55",
              confirmButtonText: "Yes",
              cancelButtonText: "No",
              closeOnConfirm: false,
              closeOnCancel: false,
          }, function(isConfirm){
            if (isConfirm) {                        
                var form = $('#barcode-form').closest('form');
                var url = form.attr('action');
                $.ajax({
                    url: url,
                    type:'POST',
                    data: form.serialize(),
                    success: function(data) {                            
                        if($.isEmptyObject(data.error)){
                            swal({
                                html:true,
                                title:"Order Submitted", 
                                text: data.success, 
                                type: "success"
                            });
                            window.location.reload();
                            // toastMessage('success',data.success);
                        }else{
                            swal({
                                html:true,
                                title:"Error!", 
                                text: data.error, 
                                type: "error"
                            });
                            // printErrorMsg(data.error);
                        }
                    }
                });
            } else {
                swal("Cancelled", "Order Cancel!", "error");
            }
        });
    }
</script>
@endpush