@extends('backend.layouts.split')

@section('title', __('labels.backend.access.roles.management') . ' | ' . __('labels.backend.access.roles.edit'))

@section('content')
{{ html()->modelForm($role, 'PATCH', route('admin.auth.role.update', $role))->class('form-horizontal')->open() }}
<div class="row" style="margin-top:25px">
    <div class="col-md-12">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <h4 class="card-title mb-0 caption-subject bold">
                    @lang('labels.backend.access.roles.management')
                    <small class="text-muted">@lang('labels.backend.access.roles.edit')</small>
                </h4>
            </div>
            <div class="portlet-body form">
                <div class="form-body">
                    <div class="row" style="padding-left:30px">
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ html()->label(__('validation.attributes.backend.access.roles.name'))->class('form-control-label')->for('name') }}
                                <div class="input-group">
                                    <span class="input-group-text input-circle-left">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    {{ html()->text('name')
                                        ->class('form-control')
                                        ->placeholder(__('validation.attributes.backend.access.roles.name'))
                                        ->attribute('maxlength', 191)
                                        ->required() }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-2">
                            {{ html()->label(__('validation.attributes.backend.access.roles.associated_permissions'))->class('col-md-2 form-control-label')->for('permissions') }}
                        </div>
                        <div class="col-md-6">
                            @if($permissions->count())
                                @foreach($permissions as $permission)
                                    <div class="checkbox d-flex align-items-center">
                                        {{ html()->label(
                                                html()->checkbox('permissions[]', in_array($permission->name, $rolePermissions), $permission->name)
                                                        ->class('icheck')
                                                        ->id('permission-'.$permission->id)
                                                    . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                                ->class('switch switch-label switch-pill switch-primary mr-2')
                                            ->for('permission-'.$permission->id) }}
                                        {{ html()->label(ucwords($permission->name))->for('permission-'.$permission->id) }}
                                    </div>
                                @endforeach
                            @endif
                        </div><!--col-->
                    </div>
                </div>
                <div class="form-actions right">
                    {{ form_cancel(route('admin.auth.role.index'), __('buttons.general.cancel')) }}
                    {{ form_submit(__('buttons.general.crud.update')) }}
                </div>
            </div>
        </div>
    </div>
</div>
{{ html()->form()->close() }}
@endsection
