@extends('backend.layouts.split')

@section('title', 'Create Template' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
    {{ html()->form('POST', route('admin.auth.template.store'))->class('form-actions top')->open() }}
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        @lang('labels.backend.access.emails.management')
                        <small class="text-muted">@lang('labels.backend.access.emails.create')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.frontend.templates.title'))->class('control-label')->for('title') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('title')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.frontend.templates.title'))
                                            ->attribute('maxlength', 191)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.frontend.templates.response_ok'))->class('control-label')->for('response_ok') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('response_ok')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.frontend.templates.response_ok'))
                                            ->attribute('maxlength', 191)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.frontend.templates.response_no'))->class('control-label')->for('response_no') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('response_no')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.frontend.templates.response_no'))
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{ html()->label('Subject')->class('control-label')->for('subject') }}
                                    <textarea class="ckeditor form-control" name="subject" rows="6" data-error-container="#subject_error"></textarea>
                                    <div id="subject_error"> </div>
                                </div>
                            </div>
                            <div class="col-md-12" style="padding:0%">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        {{ html()->label('Description')->class('control-label')->for('description') }}
                                        <textarea class="ckeditor form-control" name="description" rows="6" data-error-container="#editor2_error"></textarea>
                                        <div id="editor2_error"> </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.template.index'), __('buttons.general.cancel')) }}
                        {{ form_submit(__('buttons.general.crud.create')) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection